package org.jboss.refarch.eap6.cli;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

import org.jboss.dmr.ModelNode;

public class Resource
{

	private String name;
	private String type;
	private Resource parent;
	private List<Attribute> attributes = new ArrayList<Attribute>();
	private List<Resource> children = new ArrayList<Resource>();

	public Resource(String type, String name)
	{
		this.type = type;
		this.name = name;
	}

	public static Resource deepCopy(String type, String name, Resource source, Resource parent)
	{
		Resource copy = new Resource( type, name );
		parent.addChildResource( copy );
		for( Attribute sourceAttribute : source.attributes )
		{
			Attribute copyAttribute = new Attribute( sourceAttribute.getName(), sourceAttribute.getValue() );
			copy.addAttribute( copyAttribute );
		}
		for( Resource sourceChild : source.children )
		{
			deepCopy( sourceChild.type, sourceChild.name, sourceChild, copy );
		}
		return copy;
	}

	public Stack<Resource> getAddress()
	{
		Stack<Resource> address = new Stack<Resource>();
		address.push( this );
		for( Resource resource = this.getParent(); resource != null; resource = resource.getParent() )
		{
			address.push( resource );
		}
		return address;
	}

	public String getName()
	{
		return name;
	}

	public void setName(String name)
	{
		this.name = name;
	}

	public List<Attribute> getAttributes()
	{
		return attributes;
	}

	public Attribute getAttribute(String name)
	{
		for( Attribute attribute : attributes )
		{
			if( attribute.getName().equals( name ) )
			{
				return attribute;
			}
		}
		return null;
	}

	public void addAttribute(Attribute attribute)
	{
		attributes.add( attribute );
	}

	public void setAttribute(String name, ModelNode value)
	{
		Attribute attribute = getAttribute( name );
		if( attribute == null )
		{
			attribute = new Attribute( name, value );
			addAttribute( attribute );
		}
		else
		{
			attribute.setValue( value );
		}
	}

	public void setAttribute(String name, boolean value)
	{
		Attribute attribute = getAttribute( name );
		if( attribute == null )
		{
			attribute = new Attribute( name, value );
			addAttribute( attribute );
		}
		else
		{
			attribute.setValue( value );
		}
	}

	public void setAttribute(String name, String value)
	{
		Attribute attribute = getAttribute( name );
		if( attribute == null )
		{
			attribute = new Attribute( name, value );
			addAttribute( attribute );
		}
		else
		{
			attribute.setValue( value );
		}
	}

	public void setAttribute(String name, int value)
	{
		Attribute attribute = getAttribute( name );
		if( attribute == null )
		{
			attribute = new Attribute( name, value );
			addAttribute( attribute );
		}
		else
		{
			attribute.setValue( value );
		}
	}

	public boolean removeAttribute(String name)
	{
		return attributes.remove( getAttribute( name ) );
	}

	public List<Resource> getChildren()
	{
		return children;
	}

	public Resource getChild(String type, String name)
	{
		for( Resource child : children )
		{
			if( child.getType().equals( type ) && child.getName().equals( name ) )
			{
				return child;
			}
		}
		return null;
	}

	public void addChildResource(Resource child)
	{
		children.add( child );
		if( child.getParent() != this )
		{
			child.setParent( this );
		}
	}

	public boolean removeChildResource(String type, String name)
	{
		return children.remove( getChild( type, name ) );
	}

	public String getType()
	{
		return type;
	}

	public void setType(String type)
	{
		this.type = type;
	}

	public Resource getParent()
	{
		return parent;
	}

	public void setParent(Resource parent)
	{
		this.parent = parent;
	}

	@Override
	public int hashCode()
	{
		final int prime = 31;
		int result = 1;
		result = prime * result + ( ( name == null ) ? 0 : name.hashCode() );
		result = prime * result + ( ( type == null ) ? 0 : type.hashCode() );
		return result;
	}

	@Override
	public boolean equals(Object obj)
	{
		if( this == obj )
			return true;
		if( obj == null )
			return false;
		if( getClass() != obj.getClass() )
			return false;
		Resource other = (Resource)obj;
		if( name == null )
		{
			if( other.name != null )
				return false;
		}
		else if( !name.equals( other.name ) )
			return false;
		if( type == null )
		{
			if( other.type != null )
				return false;
		}
		else if( !type.equals( other.type ) )
			return false;
		return true;
	}

	@Override
	public String toString()
	{
		return "Resource [name=" + name + ", type=" + type + ", attributes=" + attributes + ", children=" + children + "]";
	}
}