package org.jboss.refarch.eap6.cli;

import org.jboss.dmr.ModelNode;

public class Attribute
{

	private String name;
	private ModelNode value;

	public Attribute(String name, ModelNode value)
	{
		this.name = name;
		this.value = value;
	}

	public Attribute(String name, String value)
	{
		this( name, new ModelNode( value ) );
	}

	public Attribute(String name, boolean value)
	{
		this( name, new ModelNode( value ) );
	}

	public Attribute(String name, int value)
	{
		this( name, new ModelNode( value ) );
	}

	public String getName()
	{
		return name;
	}

	public void setName(String name)
	{
		this.name = name;
	}

	public ModelNode getValue()
	{
		return value;
	}

	public void setValue(ModelNode value)
	{
		this.value = value;
	}

	public void setValue(String value)
	{
		this.value = new ModelNode( value );
	}

	public void setValue(boolean value)
	{
		this.value = new ModelNode( value );
	}

	public void setValue(int value)
	{
		this.value = new ModelNode( value );
	}

	@Override
	public int hashCode()
	{
		final int prime = 31;
		int result = 1;
		result = prime * result + ( ( name == null ) ? 0 : name.hashCode() );
		result = prime * result + ( ( value == null ) ? 0 : value.hashCode() );
		return result;
	}

	@Override
	public boolean equals(Object obj)
	{
		if( this == obj )
			return true;
		if( obj == null )
			return false;
		if( getClass() != obj.getClass() )
			return false;
		Attribute other = (Attribute)obj;
		if( name == null )
		{
			if( other.name != null )
				return false;
		}
		else if( !name.equals( other.name ) )
			return false;
		if( value == null )
		{
			if( other.value != null )
				return false;
		}
		else if( !value.equals( other.value ) )
			return false;
		return true;
	}

	@Override
	public String toString()
	{
		return "Attribute [" + name + ":" + value + "]";
	}
}