#!/bin/bash -x
# version 0.1
# This assumes that the neutron-server is installed on the controller

LOGFILE=pub_private_load-balance-configuration-`hostname -s`-`date +%F_%T`.log
(

export RHN_PASSWORD="BADPASS"
export COUNTER=0

# Create function for logging purposes
__for_logs()
{
echo
echo "******"
echo "Running $1 Function"
echo "******"
echo
}

# Set up function to install load balancer packages on controller node and nuetron node
__lb_config()
{
# Run logging function
__for_logs $FUNCNAME

rhn-channel --user admin --password ${RHN_PASSWORD} -a -c rhel-x86_64-server-lb-6
yum -y install haproxy httpd

# Configure lb files
echo "interface_driver = neutron.agent.linux.interface.OVSInterfaceDriver" >> /etc/neutron/lbaas_agent.ini
echo "device_driver = neutron.services.loadbalancer.drivers.haproxy.namespace_driver.HaproxyNSDriver" >> /etc/neutron/lbaas_agent.ini
echo "user_group = haproxy" >> /etc/neutron/lbaas_agent.ini
sed -i 's/# service_plugins =/service_plugins = neutron.services.loadbalancer.plugin.LoadBalancerPlugin/' /etc/neutron/neutron.conf
sed -i "s/'enable_lb': False/'enable_lb': True/" /etc/openstack-dashboard/local_settings

# Configure services
service httpd restart
service neutron-lbaas-agent start
service neutron-server restart
chkconfig httpd on
chkconfig neutron-lbaas-agent on
}


# Call functions here
__lb_config

) 2>&1 | tee ${LOGFILE}
echo Done. Wrote ${LOGFILE}
