#!/bin/bash -x
# aweiteka 2014-02-04
# version 0.1

LOGFILE=flat-network-config-`hostname -s`-`date +%F_%T`.log
(

export MYIP=$(hostname -i)
export KEYSTONE_IP=$MYIP
export DATA_NIC=eth1
export FLOAT_START=10.16.138.128
export FLOAT_END=10.16.138.152
export DNS_SERVER=10.16.143.247
export NETWORK="10.16.136.0/21"
export GATEWAY=REDACTED
export DEMO_CIDR="10.0.6.0/24"

# Function for logging 
__for_logs()
{
echo
echo "******"
echo "Running $1 Function"
echo "******"
echo
}

__config_network()
{
# Call logging function
__for_logs $FUNCNAME

source /root/keystonerc_admin

# create  a public / private network
source /root/keystonerc_admin
neutron net-create private
neutron subnet-create --name root-subnet private ${DEMO_CIDR} --dns-nameserver 10.16.143.247
neutron router-create router1
SUBID=$(neutron subnet-list | awk "/root-subnet/ {print \$2}")
neutron router-interface-add router1 $SUBID

neutron net-create public --router:external=True --provider:network_type flat --provider:physical_network physnet1
neutron subnet-create --name public --gateway ${GATEWAY} --allocation-pool start=${FLOAT_START},end=${FLOAT_END} public 10.16.136.0/21 --enable_dhcp=False
netid=$(neutron net-list | awk "/public/ { print \$2 }")
neutron router-gateway-set router1 ${netid}

}

__create_keypair()
{
nova keypair-add rootkp > /root/rootkp.pem
chmod 600 /root/rootkp.pem
}

__config_firewall()
{
for i in $(neutron security-group-list | awk ' /default/ { print $2 } ')
do
  # add ssh and icmp to default security groups
  neutron security-group-rule-create --direction ingress --protocol icmp  $i
  neutron security-group-rule-create --direction ingress --protocol tcp --port_range_min 22 --port_range_max 22 $i
  neutron security-group-rule-create --direction ingress --protocol tcp --port_range_min 80 --port_range_max 80 $i
  neutron security-group-rule-create --direction ingress --protocol tcp --port_range_min 443 --port_range_max 443 $i
  neutron security-group-show $i
done
}

# Call functions here
__config_network
__create_keypair
__config_firewall
) 2>&1 | tee ${LOGFILE}
echo Done. Wrote ${LOGFILE}

