#!/bin/bash -x
# version 0.1

export NODES="ose-osp-ctrl ose-osp-comp1 ose-osp-comp2"
export RHN_PASSWORD="BADPASS"

LOGFILE=packstack-install-RDO-`hostname -s`-`date +%F_%T`.log
(

# Function for logs.  
__for_logs()
{
echo
echo "******"
echo "Running $1 Function"
echo "******"
echo
}

__install_packages()
{
# Call logging function
__for_logs $FUNCNAME

# install these packages on the controller host
yum -y install git
}

__gen_ssh_key()
{
# Call logging function
__for_logs $FUNCNAME

ssh-keygen -t rsa -N '' -f ~/.ssh/id_rsa
}

__configure_servers()
{
# Call logging function
__for_logs $FUNCNAME

for node in ${NODES}
do
  ssh-copy-id -i ~/.ssh/id_rsa.pub $node

  ssh $node rhn-channel --user admin --password ${RHN_PASSWORD} -a \
-c rhel-x86_64-server-rh-common-6 \
-c rhel-x86_64-server-6-rhscl-1 \
-c rhel-x86_64-server-6-ost-4 \
-c rhel-x86_64-server-optional-6 \
-c rhel-x86_64-server-6-mrg-messaging-2 

  ssh $node virsh net-destroy default
  ssh $node virsh net-undefine default
  ssh $node \cp ifcfg-eth1 /etc/sysconfig/network-scripts/.
  ssh $node echo "vi='vim'" >> /root/.bashrc
done

yum -y install openstack-packstack
packstack --answer-file=rhel-osp-4-GA-answer.txt

for node in ${NODES}
do
  ssh $node ip link set eth1 up
done
}

__update_nova_conf()
{
  sed -i "s/#dhcp_domain=novalocal/dhcp_domain=ose.example.com/" /etc/nova/nova.conf
}
# Call functions here
__gen_ssh_key
__configure_servers
__install_packages
__update_nova_conf

) 2>&1 | tee ${LOGFILE}
echo Done. Wrote ${LOGFILE}

echo
echo
echo "Reboot all the servers so the new kernel is used"
echo "for i in ose-osp-comp1 ose-osp-comp2 ose-osp-ctrl; do ssh \$i reboot; done"
