/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.jboss.support;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

public class PageSaveConcurrencyFilter
implements Filter {
    private static Set<String> pageSaveInProgress = Collections.synchronizedSet(new HashSet());
    private static final int DEFAULT_MAX_RETRY = 100;
    private static int maxRetry = 100;

    public void init(FilterConfig filterConfig) {
        try {
            maxRetry = Integer.parseInt(filterConfig.getInitParameter("maxRetry"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        String servletPath = req.getServletPath();
        if ("UIPageEditor".equals(req.getParameter("portal:componentId")) && "Finish".equals(req.getParameter("portal:action"))) {
            pageSaveInProgress.add(servletPath);
            try {
                chain.doFilter(request, response);
            }
            finally {
                pageSaveInProgress.remove(servletPath);
            }
            return;
        }
        for (int i = 0; i < maxRetry && pageSaveInProgress.contains(servletPath); ++i) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (i != maxRetry - 1) continue;
            System.out.println("WARN: Reached to maxRetry (" + maxRetry + "). This could be a slowness issue in Portal. We recommend to capture several thread dumps.");
            pageSaveInProgress.remove(servletPath);
        }
        chain.doFilter(request, response);
    }
}

