/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.jboss.support;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

public class DashboardConcurrencyFilter
implements Filter {
    private static Set<String> userSiteCreationInProgress = Collections.synchronizedSet(new HashSet());
    private static Set<String> userSiteCreated = Collections.synchronizedSet(new HashSet());
    private static final int DEFAULT_MAX_RETRY = 100;
    private static int maxRetry = 100;

    public void init(FilterConfig filterConfig) {
        try {
            maxRetry = Integer.parseInt(filterConfig.getInitParameter("maxRetry"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String user = this.getUser(request);
        if (user == null) {
            chain.doFilter(request, response);
            return;
        }
        if (userSiteCreated.contains(user)) {
            chain.doFilter(request, response);
            return;
        }
        if (!userSiteCreationInProgress.contains(user)) {
            userSiteCreationInProgress.add(user);
            try {
                chain.doFilter(request, response);
            }
            finally {
                userSiteCreationInProgress.remove(user);
            }
            userSiteCreated.add(user);
            return;
        }
        for (int i = 0; i < maxRetry; ++i) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (!userSiteCreationInProgress.contains(user)) break;
            if (i != maxRetry - 1) continue;
            System.out.println("WARN: Reached to maxRetry (" + maxRetry + "). This could be a slowness issue in Portal. We recommend to capture several thread dumps.");
            userSiteCreationInProgress.remove(user);
        }
        chain.doFilter(request, response);
    }

    private String getUser(ServletRequest request) {
        HttpServletRequest httpReq = (HttpServletRequest)request;
        String servletPath = httpReq.getServletPath();
        String[] tokens = servletPath.split("/");
        if (tokens.length < 3) {
            return null;
        }
        return tokens[2];
    }
}

