// This source code is not supported by Red Hat. The author cannot do all guarantee about
// every disadvantage that the third person suffers by using this.

package com.redhat.jboss.support;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

import javax.mail.internet.MimeUtility;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ContentDispositionFilter implements Filter {

	private static Log log = LogFactory.getLog(ContentDispositionFilter.class);

	private final String CONTENT_DISPOSITION = "Content-Disposition";
	private final String FILENAME_ATTR = "filename=";

	public void init(FilterConfig filterConfig) {
	}

	public void destroy() {
	}

	public void doFilter(ServletRequest request, ServletResponse response,
			FilterChain chain) throws IOException, ServletException {

		String agent = ((HttpServletRequest)request).getHeader("User-Agent");
		if (agent != null) {
			agent = agent.toUpperCase();
		} else {
			agent = "";
		}
		
		chain.doFilter(request, new TempResponseWrapper(
				(HttpServletResponse) response, agent));

	}

	class TempResponseWrapper extends HttpServletResponseWrapper {
		
		private String agent;

		public TempResponseWrapper(HttpServletResponse response, String agent) {
			super(response);
			this.agent = agent;
		}

		public void setHeader(String key, String value) {
			if (key.equals(CONTENT_DISPOSITION)) {
				value = encodeFilename(value);
			}
			super.setHeader(key, value);
		}

		public void addHeader(String key, String value) {
			if (key.equals(CONTENT_DISPOSITION)) {
				value = encodeFilename(value);
			}
			super.addHeader(key, value);
		}

		private String encodeFilename(String value) {
			log.debug("encoding Content-Disposition : before = " + value);

			int index = value.indexOf(FILENAME_ATTR);
			if (index != -1) {
				int filenameStart = index + FILENAME_ATTR.length();
				int filenameEnd = value.indexOf(";", filenameStart);
				if (filenameEnd == -1) {
					filenameEnd = value.length();
				}
				String filename = value.substring(filenameStart, filenameEnd);
				if (filename != null && filename.length() > 0) {
					try {

						if(agent.indexOf("MSIE") > -1) {
							filename = URLEncoder.encode(filename, "UTF-8");
						} else if(agent.indexOf("FIREFOX") > -1 || agent.indexOf("CHROME") > -1){
							filename = MimeUtility.encodeWord(filename, "ISO-2022-JP", "B");
						} else {
							log.debug("unsupported User-Agent : " + agent);
						}
					} catch (UnsupportedEncodingException e) {
						throw new RuntimeException(e);
					}
					value = value.substring(0, filenameStart) + filename
							+ value.substring(filenameEnd);
				}
			}
			log.debug("encoding Content-Disposition : after = " + value);
			return value;
		}
	}
}