/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.jboss.support;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.mail.internet.MimeUtility;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ContentDispositionFilter
implements Filter {
    private static Log log = LogFactory.getLog(ContentDispositionFilter.class);
    private final String CONTENT_DISPOSITION = "Content-Disposition";
    private final String FILENAME_ATTR = "filename=";

    public void init(FilterConfig filterConfig) {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String agent = ((HttpServletRequest)request).getHeader("User-Agent");
        agent = agent != null ? agent.toUpperCase() : "";
        chain.doFilter(request, (ServletResponse)new TempResponseWrapper((HttpServletResponse)response, agent));
    }

    class TempResponseWrapper
    extends HttpServletResponseWrapper {
        private String agent;

        public TempResponseWrapper(HttpServletResponse response, String agent) {
            super(response);
            this.agent = agent;
        }

        public void setHeader(String key, String value) {
            if (key.equals("Content-Disposition")) {
                value = this.encodeFilename(value);
            }
            super.setHeader(key, value);
        }

        public void addHeader(String key, String value) {
            if (key.equals("Content-Disposition")) {
                value = this.encodeFilename(value);
            }
            super.addHeader(key, value);
        }

        private String encodeFilename(String value) {
            log.debug((Object)("encoding Content-Disposition : before = " + value));
            int index = value.indexOf("filename=");
            if (index != -1) {
                String filename;
                int filenameStart = index + "filename=".length();
                int filenameEnd = value.indexOf(";", filenameStart);
                if (filenameEnd == -1) {
                    filenameEnd = value.length();
                }
                if ((filename = value.substring(filenameStart, filenameEnd)) != null && filename.length() > 0) {
                    try {
                        if (this.agent.indexOf("MSIE") > -1) {
                            filename = URLEncoder.encode(filename, "UTF-8");
                        } else if (this.agent.indexOf("FIREFOX") > -1 || this.agent.indexOf("CHROME") > -1) {
                            filename = MimeUtility.encodeWord((String)filename, (String)"ISO-2022-JP", (String)"B");
                        } else {
                            log.debug((Object)("unsupported User-Agent : " + this.agent));
                        }
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new RuntimeException(e);
                    }
                    value = value.substring(0, filenameStart) + filename + value.substring(filenameEnd);
                }
            }
            log.debug((Object)("encoding Content-Disposition : after = " + value));
            return value;
        }
    }
}

