#!/bin/bash 
# The expectation is that this script will be passed as user-data and will
# configure a single VM to be a frontend for an instance wordpress 

# An additional script is passed using config-drive along with a few parameters in metadata

# example launch: 
#     nova  boot --config-drive=true --image rhel64 \
#     --user-data /pub/projects/rhos/folsom/scripts/wp-all-in-one.sh  \
#     --flavor 2 --key-name novakp vm2 \
#     --file sysreg.sh=/pub/projects/rhos/folsom/scripts/sysreg.sh \
#     --meta sysregopts="-u admin -p 100yard- -s https://ra-ns1.cloud.lab.eng.bos.redhat.com/XMLRPC -r http://ra-ns1.cloud.lab.eng.bos.redhat.com/pub/rhn-org-trusted-ssl-cert-1.0-1.noarch.rpm" \
#      --meta rhncreds="-u admin -p 100yard-" \
#      --meta wp_mysql_ip="10.10.10.10"  (No defaults, required)
#
# 3 optional metadata values will all default to 'wordpress' unless a value is supplies
#      --meta wp_db="wordpress"
#      --meta wp_user="wordpress"
#      --meta wp_passwd="wordpress"
#




function getmeta() {
  # this function set the variable metavalue to the meta-data value associated with the passed parameters
  metavalue=`cat /rhos/openstack/latest/meta_data.json | tr ',' '\n' | grep $1 |  sed 's/\"meta\"://' | cut -d\" -f4`
}

  #echo contfn=`cat /rhos/openstack/latest/meta_data.json | tr ',' '\n' | grep -A1 $1  | tail -1 | cut -d\" -f4` > /tmp/contfn_call
function getfile() {
  # this function will create a file in /var/run/myrhos associated with the passed parameter
  contfn=`cat /rhos/openstack/latest/meta_data.json | tr ',' '\n' | grep -A1 $1  | tail -1 | cut -d\" -f4`
  mkdir /var/run/myrhos
  cp /rhos/openstack$contfn /var/run/myrhos/$1
}


#
# Mount config drive
#
mkdir -p /rhos
mount /dev/disk/by-label/config-2 /rhos


#
# Register System
#

#get script
getfile "sysreg.sh"
chmod +x /var/run/myrhos/sysreg.sh


#get paramters
getmeta "sysregopts" 

#call script with parameters
/var/run/myrhos/sysreg.sh $metavalue

#
# Configure repos
#

# add optional channels
if [[ -z `yum repolist | grep  "RHN Classic"` ]]
then
  yum-config-manager  --enable rhel-6-server-optional-rpms
else
  #get creds
  getmeta "rhncreds" 
  rhn-channel $metavalue -a -c rhel-x86_64-server-optional-6
fi

# get epel
yum localinstall -y http://mirrors.servercentral.net/fedora/epel/6/x86_64/epel-release-6-8.noarch.rpm

#disable EPEL
sed -i  's/enabled=1/enabled=0/' /etc/yum.repos.d/epel.repo

#
# Install WP
#
yum install -y --enablerepo=epel wordpress

# get parameters
getmeta wp_db
wp_db=${metavalue:-wordpress}
getmeta wp_user
wp_user=${metavalue:-wordpress}
getmeta wp_passwd
wp_passwd=${metavalue:-wordpress}
getmeta wp_mysql_ip
wp_mysql_ip=${metavalue}


#
# Configure web
#
chkconfig httpd on
cp /etc/wordpress/wp-config.php /etc/wordpress/wp-config.php.orig
sed -i "s/database_name_here/${wp_db}/" /etc/wordpress/wp-config.php
sed -i "s/username_here/${wp_user}/" /etc/wordpress/wp-config.php
sed -i "s/password_here/${wp_passwd}/" /etc/wordpress/wp-config.php
sed -i "/DB_HOST/ s/localhost/${wp_mysql_ip}/" /etc/wordpress/wp-config.php
lokkit -s http
/sbin/restorecon -Rv /etc/wordpress
setsebool -P httpd_can_network_connect=1
sed -i '/Allow from 127.0.0.1/ a\
    Allow from 10.0.0.0/8' /etc/httpd/conf.d/wordpress.conf
service httpd start
