#!/bin/bash 
# The expectation is that this script will be passed as user-data and will
# configure a single VM to host the MySQL database for a wordpress instance

# An additional script is passed using config-drive along with a few parameters in metadata

# example launch: 
#     nova  boot --config-drive=true --image rhel64 \
#     --user-data /pub/projects/rhos/folsom/scripts/wp-all-in-one.sh  \
#     --flavor 2 --key-name novakp vm2 \
#     --file sysreg.sh=/pub/projects/rhos/folsom/scripts/sysreg.sh \
#     --meta sysregopts="-u admin -p 100yard- -s https://ra-ns1.cloud.lab.eng.bos.redhat.com/XMLRPC -r http://ra-ns1.cloud.lab.eng.bos.redhat.com/pub/rhn-org-trusted-ssl-cert-1.0-1.noarch.rpm" \
#      --meta rhncreds="-u admin -p 100yard-"
#
# 3 optional metadata values will all default to 'wordpress' unless a value is supplies
#      --meta wp_db="wordpress"
#      --meta wp_user="wordpress"
#      --meta wp_passwd="wordpress"
#
# if a volume is attached to the vm, it will be used to hold the mysql data
#   A check will be performed to see if the volume has a file system, if so it will be used as it
#   If the volume does not have a file system, it will be create and labelled before use
#  Use the following with nova boot to pass a volume:  --block-device-mapping /dev/vdf=404d2b8e-a174-4d4c-9bfb-6091dc480a01(volume id):::0




function getmeta() {
  # this function set the variable metavalue to the meta-data value associated with the passed parameters
  metavalue=`cat /rhos/openstack/latest/meta_data.json | tr ',' '\n' | grep $1 |  sed 's/\"meta\"://' | cut -d\" -f4`
}

  #echo contfn=`cat /rhos/openstack/latest/meta_data.json | tr ',' '\n' | grep -A1 $1  | tail -1 | cut -d\" -f4` > /tmp/contfn_call
function getfile() {
  # this function will create a file in /var/run/myrhos associated with the passed parameter
  contfn=`cat /rhos/openstack/latest/meta_data.json | tr ',' '\n' | grep -A1 $1  | tail -1 | cut -d\" -f4`
  mkdir /var/run/myrhos
  cp /rhos/openstack$contfn /var/run/myrhos/$1
}


#
# Mount config drive
#
mkdir -p /rhos
mount /dev/disk/by-label/config-2 /rhos

#
# Handle optional DB volume, could also be a Ephemeral, preference will be 
# given to a drive labeled `MYSQL then last drive
#

#verify no drive labelled mysql
if [[ -z `ls  /dev/disk/by-label/ | grep MYSQL` ]]
then

  #identify config drive
  cfgdrv=`basename $(ls -l /dev/disk/by-label/config-2 | awk '{print $NF}')`

  #get sorted list of extra drives, exlude vda (OS) and confg drive
  edrives=`cat /proc/partitions  | grep -v vda | grep vd | awk '{print $4}' | grep -v $cfgdrv | sort`

  #decide which drive should be used
  if [[ -n $edrives ]] #if there are drives
  then
      dbdrive="/dev/`echo $edrives | tail -1 | awk '{print $NF}'`"
  fi
  #with new drive decided, let create FS and fix permissions
  mkfs.ext4 -L MYSQL $dbdrive
  mount -L MYSQL /mnt
  chown 27.27 /mnt
  chcon system_u:object_r:mysqld_db_t:s0 /mnt
  umount /mnt
fi


# Attempt to mount mysql drive, if it fails, will use OS fs
sleep 1
mkdir /var/lib/mysql
chown 27.27 /mnt
chcon system_u:object_r:mysqld_db_t:s0 /mnt
sleep 2
mount -L MYSQL /var/lib/mysql


#
# Register System
#

#get script
getfile "sysreg.sh"
chmod +x /var/run/myrhos/sysreg.sh


#get paramters
getmeta "sysregopts" 

#call script with parameters
/var/run/myrhos/sysreg.sh $metavalue


#
# Configure DB
#

# get user and password
getmeta wp_db
wp_db=${metavalue:-wordpress}
getmeta wp_user
wp_user=${metavalue:-wordpress}
getmeta wp_passwd
wp_passwd=${metavalue:-wordpress}
getmeta wp_http_ip
wp_ip=${metavalue:-10.0.5.200}

# install mysql
yum -y install mysql-server

# configure
service mysqld start
chkconfig mysqld on
lokkit -p 3306:tcp

# compute hostname wildcard
#thishost=`curl http://169.254.169.254/1.0/meta-data/hostname`
getmeta "hostname"
wildhost="%.`echo $metavalue|cut -f2- -d'.'`"
 
#check to see if database already exists, create otherwise
if [[ -z `mysqlshow | grep "$wp_db "` ]]
then
  mysql -u root -e "create database ${wp_db}"
  mysql -u root -e "grant all on ${wp_db}.* to ${wp_user}@'${wildhost}';"
  mysql -u root -e "set password for ${wp_user}@'${wildhost}' = password('${wp_passwd}');"
  mysql -u root -e "grant all on ${wp_db}.* to ${wp_user}@'${wp_ip}';"
  mysql -u root -e "set password for ${wp_user}@'${wp_ip}' = password('${wp_passwd}');"
fi

