#!/bin/bash
#
# this script can be used to register the system with a red hat provider
#
usage()
{
cat<<EOF
  Usage:  $0 options
      Classic
           -k key | { -u username -p password }
           [-s satelliteURL -r satCertRPMURL] (if not specified, uses hosted)
      Certificate
           -c 
           -k key | { -u username -p password }
           [-s ManagerURL -r bootstrapRPMURL] (if not specified, uses hosted)

      -h  Show this message
EOF
}

if [[ $# -lt 1 ]]
then
   echo " Must specify at least a key or a username and password"
   usage
   exit 1
fi

#
#Parse Args
#

#Set variable empty
RegType='Classic'
ActKey=
LocType="Hosted"
User=
Passwd=
SysURL=
RPMURL=

#extract values
while getopts "hck:u:p:s:r:" ARG
do
  case $ARG in
    h)
      usage
      exit
      ;;
    c)
      RegType='Certificate'
      ;;
    k)
      ActKey=$OPTARG
      ;;
    u)
      User=$OPTARG
      ;;
    p)
      Passwd=$OPTARG
      ;;
    s)
      SysURL=$OPTARG
      LocType="Local"
      ;;
    r)
      RPMURL=$OPTARG
      LocType="Local"
      ;;
    *)
      echo "Unknown option: $ARG"
      usage
      exit 1
      ;;
    
  esac
done
    
#Error Checks
if [[ -z $ActKey ]]
then
   if [[ -z $User  || -z $Passwd ]]
   then
     echo "Username and password must both be specified if no key specified"
     usage
     exit 1
   fi
fi

if [[ $LocType == "Local" ]]
then
  if [[ -z $SysURL || -z $RPMURL ]] 
  then
    echo "When not using Hosted, both '-s' and '-r' must be specified"
    usage
    exit 1
  fi
fi


opts="--force"  

# set key or credentials
if [[ -z $ActKey ]]
then
  opts="$opts --username $User --password $Passwd"
else
  opts="$opts --activatekey $ActKey"
fi

#if not hosted, install either cert RPM or SE bootstrap
if [[ $LocType == "Local" ]]
then
 rpm -ivh $RPMURL
fi

if [[ $RegType == "Classic" ]]
then
  if [[ $LocType == "Local" ]]
  then
    opts="$opts --serverUrl $SysURL --sslCACert /usr/share/rhn/RHN-ORG-TRUSTED-SSL-CERT"
  fi
  rhnreg_ks $opts
else
  if [[ $LocType == "Local" ]]
  then
    opts="$opts --serverurl $SysURL"
  fi
  if [[ -f /etc/sysconfig/rhn/systemid ]]
  then
     \mv /etc/sysconfig/rhn/systemid /root/
  fi
  opts="register $opts --auto-attach"
  subscription-manager $opts
fi
