#!/bin/bash

readonly RESULT_DIR=$(mktemp -d)

for iteration in {1..100}
do
  iteration_resultdir="${RESULT_DIR}/${iteration}"
  mkdir -p "${iteration_resultdir}"

  top -n 5 -b > "${iteration_resultdir}/top.out" &
  vmstat 1 50 > "${iteration_resultdir}/vm.out" &
  iostat -tkx 2 10 > "${iteration_resultdir}/io.out" &
  ps aux > "${iteration_resultdir}/ps.out" &
  ps -eLf > "${iteration_resultdir}/psh.out" &
  sar 1 50 > "${iteration_resultdir}/sar.out" &
  free > "${iteration_resultdir}/free.out" &
  sleep 1
  echo "Iteration ${iteration} done."
done

tar -cjvf outputs.tar.bz2 "${RESULT_DIR}/"
