package jboss.example;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.jboss.dependency.spi.Controller;
import org.jboss.dependency.spi.ControllerState;

import org.jboss.deployers.plugins.main.MainDeployerImpl;

import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStage;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.spi.deployer.helpers.AbstractDeployer;
import org.jboss.deployers.structure.spi.DeploymentContext;
import org.jboss.deployers.structure.spi.DeploymentUnit;

public class PostInstallDeployer extends AbstractDeployer implements PostInstallDeployerMBean
{
   private List<String> deployments = new ArrayList<String>();
   private MainDeployerImpl mainDeployer;
   private Controller controller;

   public void setMainDeployer(MainDeployerImpl md)
   {
      mainDeployer = md;
   }

   public void create()
   {
      // Create a new ControllerState that follows the "Installed" state and 
      // add it to the controller.  The controller is the KernelController injected
      // in the bean definition of this deployer
      ControllerState state = new ControllerState("PostInstall");
      controller.addState(state, ControllerState.INSTALLED);

      // Create the new DeploymentStage following the "Installed" DeploymentStage
      // and set it to the stage of interest to this deployer
      DeploymentStage stage = new DeploymentStage("PostInstall", DeploymentStages.INSTALLED);
      setStage(stage);
   }

   public void setController(Controller controller)
   {
      this.controller = controller;
   }

   public void deploy(DeploymentUnit du) throws DeploymentException
   {
      String deploymentName = du.getSimpleName();
      log.info("Added deployment " + deploymentName);
      deployments.add(deploymentName);
   }

   @Override
   public void undeploy(DeploymentUnit du)
   {
      String deploymentName = du.getSimpleName();
      log.info("Removed deployment " + deploymentName);
      deployments.remove(deploymentName);
   }

   public String showDeploymentsEncountered()
   {
      StringBuilder buffer = new StringBuilder();
      for (String name: deployments)
      {
         buffer.append(name);
         buffer.append("\n");
      }
      return buffer.toString();
   }

   public String listDeployments()
   {
      StringBuilder buffer = new StringBuilder();
      Collection<DeploymentContext> contexts = mainDeployer.getAll();
      for (DeploymentContext context: contexts)
      {
         buffer.append(context.getName());
         buffer.append("\n");
      }
      return buffer.toString();
   }
}
