import java.net.UnknownHostException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.sasl.RealmCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.ModelControllerClient.Factory;
import java.net.InetAddress;
import java.io.IOException;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import java.util.*;


public class TestDataSource
  {     
    //static String host = "localhost"; 
    static String host = "10.65.223.46";  // Make sure your are running your Standalone profile IP Address as   ./standalone.sh -bmanagement 10.65.223.46
    static String password = "admin";     // ManagementRealm user credentials
    static String userid = "admin1";  
    static ModelControllerClient client = null;
    public static void main (String[] args) 
      {
          
          try 
            {
                client = createClient (InetAddress.getByName(host), 9999, userid, password.toCharArray(), "ManagementRealm" );
            }
          catch ( UnknownHostException uhe) 
            {
               System.out.println("UHE: " + uhe.getMessage());
            }

          try {
                    TestDataSource testDataSource=new TestDataSource();
                    List<ModelNode> listNonXADataSource=listNonXADataSource();
                    System.out.print("\n\n\t******Available Non-XA DataSources are: "+listNonXADataSource+"\n\n");     
 
                    for(ModelNode dsNode : listNonXADataSource)
                      {
                             String dsName=dsNode.toString();
                             dsName=dsName.replace("\"","");
                             testDataSource.testNonXADataSource(dsName.toString()); 
                      }

                    List<ModelNode> listXADataSource=listXADataSource();
                    System.out.print("\n\n\t******Available Non-XA DataSources are: "+listXADataSource+"\n\n");     
                    for(ModelNode dsNode : listXADataSource)
                      {
                             String dsName=dsNode.toString();
                             dsName=dsName.replace("\"","");
                             testDataSource.testXADataSource(dsName.toString()); 
                      }
                   if (client != null ) client.close();
              }
           catch (Exception e)
              {
                  System.out.println ("Exception: " + e.getMessage());
                  e.printStackTrace();
               }
        }


      public static void testNonXADataSource(String dataSourceName) throws Exception
       {
                 ModelNode op = new ModelNode(); 
                 op.get("operation").set("test-connection-in-pool"); 
                 ModelNode address = op.get("address"); 
                 address.add("subsystem", "datasources"); 
                 address.add("data-source", dataSourceName); 
                 op.get("operations").set(true);
  
                 ModelNode returnVal = client.execute(op); 
                 String result=returnVal.get("result").toString();
                 String path="/subsystem=datasources/data-source="+dataSourceName;
                 if(result.equals("[true]")) 
                    {
                       System.out.println("\n\tNon XA DataSource \""+dataSourceName+"\" is RUNNING Successfully.");
                    }
                 else if(result.equals("[false]")) 
                    {
                      System.out.println("\n\tNon XA DataSource \""+dataSourceName+"\" is test FAILED");
                    }
             else if(result.equals("undefined")) 
                {
                   System.out.println("\n\tDataSource \""+dataSourceName+"\" test FAILED");
                }
         }


      public static void testXADataSource(String xaDataSourceName) throws Exception 
       {
                 ModelNode op = new ModelNode(); 
                 op.get("operation").set("test-connection-in-pool"); 
                 ModelNode address = op.get("address"); 
                 address.add("subsystem", "datasources"); 
                 address.add("xa-data-source", xaDataSourceName); 
                 op.get("operations").set(true);
  
                 ModelNode returnVal = client.execute(op); 
                 String result=returnVal.get("result").toString();
                 String path="/subsystem=datasources/xa-data-source="+xaDataSourceName;
                 if(result.equals("[true]")) 
                    {
                       System.out.println("\n\tXA DataSource \""+xaDataSourceName+"\" is RUNNING Successfully.");
                    }
                 else if(result.equals("[false]")) 
                    {
                      System.out.println("\n\tXA DataSource \""+xaDataSourceName+"\" is test FAILED");
                    }
                 else if(result.equals("undefined")) 
                    {
                   System.out.println("\n\tXA DataSource \""+xaDataSourceName+"\" test FAILED");
                    }        
         }


      public static List<ModelNode> listNonXADataSource() throws Exception 
       {
                 ModelNode op = new ModelNode(); 
                 op.get("operation").set("read-children-names"); 
                 op.get("child-type").set("data-source");
                 ModelNode address = op.get("address"); 
                 address.add("subsystem", "datasources"); 
                 op.get("operations").set(true);
  
                 ModelNode returnVal = client.execute(op); 
                 String listOfDataSources=returnVal.get("result").toString();
                 return returnVal.get("result").asList();
         }

      public static List<ModelNode> listXADataSource() throws Exception 
       {
                 ModelNode op = new ModelNode(); 
                 op.get("operation").set("read-children-names"); 
                 op.get("child-type").set("xa-data-source");
                 ModelNode address = op.get("address"); 
                 address.add("subsystem", "datasources"); 
                 op.get("operations").set(true);
  
                 ModelNode returnVal = client.execute(op); 
                 String listOfDataSources=returnVal.get("result").toString();
                 return returnVal.get("result").asList();
         }

      static ModelControllerClient createClient (final InetAddress host, final int port,  final String username, final char[] password, final String securityRealmName) 
       {  
         final CallbackHandler callbackHandler = new CallbackHandler() 
          { 
             public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException 
               {
                  for (Callback current : callbacks) 
                   { 
                      if (current instanceof NameCallback) 
                        { 
                           NameCallback ncb = (NameCallback) current; 
                           ncb.setName(new String(password));
                        } 
                      else if (current instanceof PasswordCallback) 
                        { 
                            PasswordCallback pcb = (PasswordCallback) current; 
                            pcb.setPassword(username.toCharArray()); 
                        }
                      else if (current instanceof RealmCallback) 
                         { 
                            RealmCallback rcb = (RealmCallback) current; 
                            rcb.setText(rcb.getDefaultText()); 
                         } 
                      else { 
                            throw new UnsupportedCallbackException(current); 
                         } 
                     } 
                  } 
                }; 
            return ModelControllerClient.Factory.create(host, port, callbackHandler); 
          }
   }
