/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.List;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;

public class TestDataSource {
    static String host = "10.65.223.46";
    static String password = "admin";
    static String userid = "admin1";
    static ModelControllerClient client = null;

    public static void main(String[] stringArray) {
        try {
            client = TestDataSource.createClient(InetAddress.getByName(host), 9999, userid, password.toCharArray(), "ManagementRealm");
        }
        catch (UnknownHostException unknownHostException) {
            System.out.println("UHE: " + unknownHostException.getMessage());
        }
        try {
            String string;
            TestDataSource testDataSource = new TestDataSource();
            List<ModelNode> list = TestDataSource.listNonXADataSource();
            System.out.print("\n\n\t******Available Non-XA DataSources are: " + list + "\n\n");
            for (ModelNode object2 : list) {
                string = object2.toString();
                string = string.replace("\"", "");
                TestDataSource.testNonXADataSource(string.toString());
            }
            List<ModelNode> list2 = TestDataSource.listXADataSource();
            System.out.print("\n\n\t******Available Non-XA DataSources are: " + list2 + "\n\n");
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                string = (ModelNode)iterator.next();
                String string2 = string.toString();
                string2 = string2.replace("\"", "");
                TestDataSource.testXADataSource(string2.toString());
            }
            if (client != null) {
                client.close();
            }
        }
        catch (Exception exception) {
            System.out.println("Exception: " + exception.getMessage());
            exception.printStackTrace();
        }
    }

    public static void testNonXADataSource(String string) throws Exception {
        ModelNode modelNode = new ModelNode();
        modelNode.get("operation").set("test-connection-in-pool");
        ModelNode modelNode2 = modelNode.get("address");
        modelNode2.add("subsystem", "datasources");
        modelNode2.add("data-source", string);
        modelNode.get("operations").set(true);
        ModelNode modelNode3 = client.execute(modelNode);
        String string2 = modelNode3.get("result").toString();
        String string3 = "/subsystem=datasources/data-source=" + string;
        if (string2.equals("[true]")) {
            System.out.println("\n\tNon XA DataSource \"" + string + "\" is RUNNING Successfully.");
        } else if (string2.equals("[false]")) {
            System.out.println("\n\tNon XA DataSource \"" + string + "\" is test FAILED");
        } else if (string2.equals("undefined")) {
            System.out.println("\n\tDataSource \"" + string + "\" test FAILED");
        }
    }

    public static void testXADataSource(String string) throws Exception {
        ModelNode modelNode = new ModelNode();
        modelNode.get("operation").set("test-connection-in-pool");
        ModelNode modelNode2 = modelNode.get("address");
        modelNode2.add("subsystem", "datasources");
        modelNode2.add("xa-data-source", string);
        modelNode.get("operations").set(true);
        ModelNode modelNode3 = client.execute(modelNode);
        String string2 = modelNode3.get("result").toString();
        String string3 = "/subsystem=datasources/xa-data-source=" + string;
        if (string2.equals("[true]")) {
            System.out.println("\n\tXA DataSource \"" + string + "\" is RUNNING Successfully.");
        } else if (string2.equals("[false]")) {
            System.out.println("\n\tXA DataSource \"" + string + "\" is test FAILED");
        } else if (string2.equals("undefined")) {
            System.out.println("\n\tXA DataSource \"" + string + "\" test FAILED");
        }
    }

    public static List<ModelNode> listNonXADataSource() throws Exception {
        ModelNode modelNode = new ModelNode();
        modelNode.get("operation").set("read-children-names");
        modelNode.get("child-type").set("data-source");
        ModelNode modelNode2 = modelNode.get("address");
        modelNode2.add("subsystem", "datasources");
        modelNode.get("operations").set(true);
        ModelNode modelNode3 = client.execute(modelNode);
        String string = modelNode3.get("result").toString();
        return modelNode3.get("result").asList();
    }

    public static List<ModelNode> listXADataSource() throws Exception {
        ModelNode modelNode = new ModelNode();
        modelNode.get("operation").set("read-children-names");
        modelNode.get("child-type").set("xa-data-source");
        ModelNode modelNode2 = modelNode.get("address");
        modelNode2.add("subsystem", "datasources");
        modelNode.get("operations").set(true);
        ModelNode modelNode3 = client.execute(modelNode);
        String string = modelNode3.get("result").toString();
        return modelNode3.get("result").asList();
    }

    static ModelControllerClient createClient(InetAddress inetAddress, int n, final String string, final char[] cArray, String string2) {
        CallbackHandler callbackHandler = new CallbackHandler(){

            @Override
            public void handle(Callback[] callbackArray) throws IOException, UnsupportedCallbackException {
                for (Callback callback : callbackArray) {
                    Callback callback2;
                    if (callback instanceof NameCallback) {
                        callback2 = (NameCallback)callback;
                        ((NameCallback)callback2).setName(new String(cArray));
                        continue;
                    }
                    if (callback instanceof PasswordCallback) {
                        callback2 = (PasswordCallback)callback;
                        ((PasswordCallback)callback2).setPassword(string.toCharArray());
                        continue;
                    }
                    if (callback instanceof RealmCallback) {
                        callback2 = (RealmCallback)callback;
                        ((TextInputCallback)callback2).setText(((TextInputCallback)callback2).getDefaultText());
                        continue;
                    }
                    throw new UnsupportedCallbackException(callback);
                }
            }
        };
        return ModelControllerClient.Factory.create((InetAddress)inetAddress, (int)n, (CallbackHandler)callbackHandler);
    }
}

