package com.sample;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.stream.Collectors;

import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.rule.GroupElement;
import org.drools.core.rule.LogicTransformer;
import org.drools.core.rule.RuleConditionElement;
import org.hibernate.service.jta.platform.internal.SynchronizationRegistryBasedSynchronizationStrategy;
import org.kie.api.KieServices;
import org.kie.api.definition.KiePackage;
import org.kie.api.definition.rule.Rule;
import org.kie.api.io.Resource;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;

/**
 * This is a sample class to launch a rule.
 */
public class DroolsTest {

    public static final void main(String[] args) {
        try {

            // load up the knowledge base
            KieServices ks = KieServices.Factory.get();
            KieContainer kContainer = ks.getKieClasspathContainer();
            KieSession kSession = kContainer.newKieSession("ksession-rules");

            for (KiePackage p : kSession.getKieBase().getKiePackages()) {

                for (Rule r : p.getRules()) {

                    RuleImpl i = (RuleImpl) r;

                    Resource x = i.getResource();

                    String result = new BufferedReader(new InputStreamReader(x.getInputStream())).lines().parallel()
                            .collect(Collectors.joining("\n"));

                    Integer start = result.indexOf(i.getName()) + i.getName().length();
                    Integer when = result.indexOf("when", start) + 4;
                    Integer then = result.indexOf("then", start);
                    Integer end = result.indexOf("end", start);

                    System.out.println("RULE NAME:" + i.getName());
                    System.out.println("RULE LHS:" + result.substring(when, then));
                    System.out.println("RULE RHS:" + result.substring(then + 4, end));

                }
            }

        } catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static class Message {

        public static final int HELLO = 0;
        public static final int GOODBYE = 1;

        private String message;

        private int status;

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public int getStatus() {
            return this.status;
        }

        public void setStatus(int status) {
            this.status = status;
        }

    }

}
