#!/bin/sh
# this part restores the envirnoment back to initial setup, so that the cli scripts can be run again. 

export SCRIPT_DIR=$(dirname "$0")
. $SCRIPT_DIR/environment.sh

# stop all jboss process
pkill -f 'jboss'

if [ -d $CONF_BACKUP_HOME ]
then
   echo "========configuration to remove: " $CONF_HOME 
   rm -rf $CONF_HOME

   echo "========restore from: " $CONF_BACKUP_HOME

   cp -r $CONF_BACKUP_HOME $CONF_HOME
else
   echo "========No configuration backup at " $CONF_BACKUP_HOME
fi

ls -l  $JBOSS_HOME/domain


echo "========clean servers folder"
rm -rf $JBOSS_HOME/domain/servers/*

echo "======== configuration is restored =========================================================="




# now start to setup the environment

echo
echo
echo "========build deployments if needed"
if [ -f ${SCRIPT_DIR}/code/webapp/target/clusterApp.war ]
then
   echo "========clusterApp.war is already built"
else
   mvn -f ${SCRIPT_DIR}/code/pom.xml install
fi



#setup master server first

$JBOSS_HOME/bin/jboss-cli.sh --properties=$SCRIPT_DIR/cluster.properties --file=$SCRIPT_DIR/setup-master.cli -Dhost.file=host.xml

THIS_HOSTNAME=`$JBOSS_HOME/bin/jboss-cli.sh  -Djboss.domain.master.address=127.0.0.1 --commands="embed-host-controller --domain-config=domain.xml --host-config=host-slave.xml,read-attribute local-host-name"`

. $SCRIPT_DIR/slaves.properties
for slave in $(echo $slaves | sed "s/,/ /g")
do
        #Variable names for each node's name and identity secret:
        name="${slave}_name"
        secret="${slave}_secret"
	liveGroup="${slave}_live_group"
	backupGroup="${slave}_backup_group"

        echo Will configure ${slave}

        #Back up host-slave as it will be overwritten by CLI:
        cp $CONF_HOME/host-slave.xml $CONF_HOME/host-slave-orig.xml

        $JBOSS_HOME/bin/jboss-cli.sh --file=$SCRIPT_DIR/setup-slave.cli -Djboss.domain.master.address=127.0.0.1 -Dhost.file=host-slave.xml -Dold.host.name=$THIS_HOSTNAME -Dhost.name=${!name} -Dserver.identity=${!secret} -Dlive.group=${!liveGroup} -Dbackup.group=${!backupGroup} --properties=$SCRIPT_DIR/cluster.properties

        #Copy final host-slave file to a directory for this node, restore the original
        mkdir $CONF_HOME/$slave
        mv $CONF_HOME/host-slave.xml $CONF_HOME/$slave/
        mv $CONF_HOME/host-slave-orig.xml $CONF_HOME/host-slave.xml
done
