package com.redhat.refarch.eap7.cluster.slsb;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;

import javax.annotation.Resource;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.jms.ConnectionFactory;
import javax.jms.JMSContext;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;

import com.redhat.refarch.eap7.cluster.jpa.Person;

@Stateless
@Remote(StatelessSession.class)
//TODO @Clustered
public class StatelessSessionBean implements StatelessSession
{

	@PersistenceContext
	private EntityManager entityManager;

	@Resource(mappedName = "java:/ConnectionFactory")
	private ConnectionFactory connectionFactory;

	@Inject
    private JMSContext jmsContext;	
	
	
	@Resource(mappedName = "java:/queue/DistributedQueue")
	private Queue queue;

	@Override
	public String getServer()
	{
		return System.getProperty( "jboss.server.name" );
	}

	@Override
	public void createPerson(Person person)
	{
		entityManager.persist( person );
	}

	@Override
	public List<Person> findPersons()
	{
		CriteriaBuilder builder = entityManager.getCriteriaBuilder();
		CriteriaQuery<Person> criteriaQuery = builder.createQuery( Person.class );
		criteriaQuery.select( criteriaQuery.from( Person.class ) );
		List<Person> persons = entityManager.createQuery( criteriaQuery ).getResultList();
		return persons;
	}

	@Override
	public String getName(Long pk)
	{
		Person entity = entityManager.find( Person.class, pk );
		if( entity == null )
		{
			return null;
		}
		else
		{
			return entity.getName();
		}
	}

	@Override
	public void replacePerson(Long pk, String name)
	{
		Person entity = entityManager.find( Person.class, pk );
		if( entity != null )
		{
			entity.setName( name );
			entityManager.merge( entity );
		}
	}

	/**
	@Override
	public void sendMessage1(String message, Integer messageCount, Long processingDelay) throws JMSException
	{
		HashMap<String, Serializable> map = new HashMap<String, Serializable>();
		map.put( "delay", processingDelay );
		map.put( "message", message );
		Connection connection = connectionFactory.createConnection();
		try
		{
			Session session = connection.createSession( false, Session.AUTO_ACKNOWLEDGE );
			MessageProducer messageProducer = session.createProducer( queue );
			connection.start();
			for( int index = 1; index <= messageCount; index++ )
			{
				map.put( "count", index );
				ObjectMessage objectMessage = session.createObjectMessage();
				objectMessage.setObject( map );
				messageProducer.send( objectMessage );
			}
		}
		finally
		{
			connection.close();
		}
	}
	*/
	
	@Override
	public void sendMessage(String message, Integer messageCount, Long processingDelay) throws JMSException
	{
		HashMap<String, Serializable> map = new HashMap<String, Serializable>();
		map.put( "delay", processingDelay );
		map.put( "message", message);

		for( int index = 1; index <= messageCount; index++ )
		{
			map.put( "count", index );
			jmsContext.createProducer().send(queue, map);
		}		
				
	}	
	
	
}

