package com.redhat.refarch.eap7.cluster.mdb;

import java.io.Serializable;
import java.util.HashMap;

import javax.ejb.ActivationConfigProperty;
import javax.ejb.MessageDriven;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;

@MessageDriven(activationConfig = {@ActivationConfigProperty(propertyName = "destinationType", propertyValue = "javax.jms.Queue"), @ActivationConfigProperty(propertyName = "destination", propertyValue = "queue/DistributedQueue"), @ActivationConfigProperty(propertyName = "maxSession", propertyValue = "1")})
public class MessageDrivenBean implements MessageListener
{

	@Override
	public void onMessage(Message message)
	{
		try
		{
			
			
			//ObjectMessage objectMessage = (ObjectMessage)message;
			//Serializable object = objectMessage.getObject();
			//@SuppressWarnings("unchecked")
			//HashMap<String, Serializable> map = (HashMap<String, Serializable>)object;
			
			@SuppressWarnings("unchecked")
			HashMap<String, Serializable> map = (HashMap<String, Serializable>) message.getBody(HashMap.class);
			
			String text = (String)map.get( "message" );
			int count = (Integer)map.get( "count" );
			long delay = (Long)map.get( "delay" );
			System.out.println( count + "  :  " + text );
			Thread.sleep( delay );
		}
		catch( JMSException e )
		{
			e.printStackTrace();
		}
		catch( InterruptedException e )
		{
			e.printStackTrace();
		}
	}
}
