/*
 * Decompiled with CFR 0.152.
 */
package com.mycompany.test.jpa.model;

import com.mycompany.test.jpa.model.ISystem;
import java.net.URI;
import java.net.URISyntaxException;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;

@Entity
public class BasicSystem
implements ISystem {
    @Id
    @GeneratedValue
    private Long id;
    @Column(unique=true)
    private String code;
    @Column
    private String name;
    @Column
    private String uri;

    public BasicSystem() {
    }

    public BasicSystem(Long id, String code, String name, URI uri) {
        this.id = id;
        this.code = code;
        this.name = name;
        this.uri = uri != null ? uri.toString() : null;
    }

    public String getCode() {
        return this.code;
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public URI getUri() {
        if (this.uri == null) {
            return null;
        }
        try {
            return new URI(this.uri);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setUri(URI uri) {
        this.uri = uri != null ? uri.toString() : null;
    }
}

