/*
 * Decompiled with CFR 0.152.
 */
package com.mycompany.test.jpa.internal.persistence;

import com.mycompany.test.interfaces.HibenrateBasicSystemInterface;
import com.mycompany.test.jpa.model.BasicSystem;
import java.net.URI;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HibernateBasicSystemRepository
implements HibenrateBasicSystemInterface {
    private EntityManager entityManager;

    @Override
    public boolean add(BasicSystem basicSystem) {
        try {
            this.entityManager.persist((Object)basicSystem);
            return true;
        }
        catch (PersistenceException e) {
            return false;
        }
    }

    @Override
    public BasicSystem get(String code) {
        try {
            return (BasicSystem)this.entityManager.createQuery("SELECT b FROM BasicSystem b WHERE b.code = :code", BasicSystem.class).setParameter("code", (Object)code).getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    @Override
    public BasicSystem get(long id) {
        return (BasicSystem)this.entityManager.find(BasicSystem.class, (Object)id);
    }

    @Override
    public boolean update(BasicSystem basicSystem) {
        BasicSystem currentBasicSystem = this.get(basicSystem.getId());
        if (currentBasicSystem != null) {
            currentBasicSystem.setCode(basicSystem.getCode());
            currentBasicSystem.setName(basicSystem.getName());
            currentBasicSystem.setUri(basicSystem.getUri());
            this.entityManager.merge((Object)currentBasicSystem);
            return true;
        }
        return false;
    }

    @Override
    public boolean delete(String code) {
        BasicSystem basicSystem = this.get(code);
        if (basicSystem != null) {
            this.entityManager.remove((Object)basicSystem);
            return true;
        }
        return false;
    }

    @Override
    public List<BasicSystem> getAll() {
        return this.entityManager.createQuery("SELECT b FROM BasicSystem b ORDER BY b.name ASC", BasicSystem.class).getResultList();
    }

    @Override
    public List<BasicSystem> getAllByUri(URI uri) {
        return this.entityManager.createQuery("SELECT b FROM BasicSystem b where b.uri = :uri", BasicSystem.class).setParameter("uri", (Object)uri.toString()).getResultList();
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }
}

