package com.redhat.gss.security;

import java.security.Principal;
import java.security.acl.Group;
import java.util.logging.Logger;

import javax.security.auth.login.LoginException;

import org.jboss.security.SimpleGroup;
import org.jboss.security.SimplePrincipal;
import org.jboss.security.auth.spi.UsernamePasswordLoginModule;

/**
 * 
 * A simple custom login module based on the class CustomLoginModule created by
 * Scott.Stark@jboss.org
 * 
 * @author wsiqueir
 * 
 */
public class SimpleCustomLoginModule extends UsernamePasswordLoginModule {
	
	Logger log = Logger.getLogger(SimpleCustomLoginModule.class.toString());
	private SimplePrincipal caller;

	public boolean login() throws LoginException {
		log.fine("Inside login()");
		if (super.login()) {
			caller = new SimplePrincipal(getUsername());
			log.fine("Returning true");
			return true;
		}
		log.fine("Returning false");
		return false;
	}

	protected Principal getIdentity() {
		log.fine("Inside getIdentity()");
		Principal identity = caller;
		if (identity == null)
			identity = super.getIdentity();
		return identity;
	}

	protected Group[] getRoleSets() throws LoginException {
		log.fine("Inside getRoleSets()");
		try {
			// The declarative permissions
			Group roles = new SimpleGroup("Roles");
			// The caller identity
			Group callerPrincipal = new SimpleGroup("CallerPrincipal");
			Group[] groups = { roles, callerPrincipal };
			log.fine("Getting roles for user=" + getUsername());
			// Add the Echo role
			roles.addMember(new SimplePrincipal("JBossAdmin"));
			// Add the custom principal for the caller
			callerPrincipal.addMember(new CustomPrincipalImpl(
					"ImaReadableUsername"));
			return groups;
		} catch (Exception e) {
			log.fine("Failed to obtain groups for user="
					+ getUsername() + " " + e);
			throw new LoginException(e.toString());
		}
	}

	protected String getUsersPassword() {
		log.fine("Inside getUsersPassword()");
		return "testing";
	}
}
