/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecms.upgrade.plugins;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.query.QueryManager;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.commons.utils.PrivilegedSystemHelper;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.cms.views.ApplicationTemplateManagerService;
import org.exoplatform.services.cms.views.impl.ApplicationTemplateManagerServiceImpl;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class WCMTemplateUpgradePlugin
extends UpgradeProductPlugin {
    private Log log = ExoLogger.getLogger(((Object)((Object)this)).getClass());
    private ApplicationTemplateManagerService appTemplateService_;

    public WCMTemplateUpgradePlugin(ApplicationTemplateManagerService appTemplateService, InitParams initParams) {
        super(initParams);
        this.appTemplateService_ = appTemplateService;
    }

    public void processUpgrade(String oldVersion, String newVersion) {
        block3: {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("Start " + ((Object)((Object)this)).getClass().getName() + "............."));
            }
            String unchangedClvTemplates = PrivilegedSystemHelper.getProperty((String)"unchanged-clv-templates");
            String unchangedSearchTemplates = PrivilegedSystemHelper.getProperty((String)"unchanged-wcm-search-templates");
            this.upgrade(unchangedClvTemplates, "content-list-viewer");
            this.upgrade(unchangedSearchTemplates, "WCM Advance Search");
            try {
                ((ApplicationTemplateManagerServiceImpl)this.appTemplateService_).start();
            }
            catch (Exception e) {
                if (!this.log.isErrorEnabled()) break block3;
                this.log.error((Object)"An unexpected error occurs when migrating templates for portlet CLV and WCMSearch: ", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upgrade(String unchangedTemplates, String portletName) {
        SessionProvider sessionProvider = null;
        if (StringUtils.isEmpty((String)unchangedTemplates)) {
            unchangedTemplates = "";
        }
        try {
            HashSet<String> unchangedTemplateSet = new HashSet<String>();
            Set configuredTemplates = this.appTemplateService_.getConfiguredAppTemplateMap(portletName);
            ArrayList<Node> removedNodes = new ArrayList<Node>();
            for (String unchangedTemplate : unchangedTemplates.split(",")) {
                unchangedTemplateSet.add(unchangedTemplate.trim());
            }
            sessionProvider = SessionProvider.createSystemProvider();
            Node templateHomeNode = this.appTemplateService_.getApplicationTemplateHome(portletName, sessionProvider);
            QueryManager queryManager = templateHomeNode.getSession().getWorkspace().getQueryManager();
            NodeIterator iter = queryManager.createQuery("SELECT * FROM nt:file WHERE jcr:path LIKE '" + templateHomeNode.getPath() + "/%'", "sql").execute().getNodes();
            while (iter.hasNext()) {
                Node templateNode = iter.nextNode();
                if (unchangedTemplateSet.contains(templateNode.getPath().substring(templateHomeNode.getPath().length() + 1)) || !configuredTemplates.contains(templateNode.getPath().substring(templateHomeNode.getPath().length() + 1))) continue;
                removedNodes.add(templateNode);
            }
            for (Node removedNode : removedNodes) {
                try {
                    removedNode.remove();
                    templateHomeNode.save();
                }
                catch (Exception e) {
                    if (!this.log.isInfoEnabled()) continue;
                    this.log.error((Object)("Error in " + this.getName() + ": Can not remove old template: " + removedNode.getPath()));
                }
            }
        }
        catch (Exception e) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("An unexpected error occurs when migrating templates for portlet: " + portletName + ": "), (Throwable)e);
            }
        }
        finally {
            if (sessionProvider != null) {
                sessionProvider.close();
            }
        }
    }

    public boolean shouldProceedToUpgrade(String previousVersion, String newVersion) {
        return true;
    }
}

