#!/bin/sh
#
# Takes the JBoss PID as an argument. 
#
# Create thread dumps a specified number of times and INTERVAL. Thread dumps 
# will be in the file where stdout was redirected or in console output.
#
# Usage: sh ./threaddump_linux.sh <JBOSS_PID>
#

# Number of times to collect data.
LOOP=6
# Interval in seconds between data points.
INTERVAL=20

for ((i=1; i <= $LOOP; i++))
do
   kill -3  $1
   echo "thread dump #" $i
   if [ $i -lt $LOOP ]; then
      echo "Sleeping..."
      sleep $INTERVAL
   fi
done
