#!/bin/bash

PROGNAME=`basename $0`
DIRNAME=`dirname $0`

OPERATION=start

if [[ "$PROGNAME" == "stopall.sh" ]]; then 
	OPERATION=stop
fi


if [[ -s $0 ]]; then 
	P=`ls -la $0 | awk ' { print $NF } ' `
	DIRNAME=`dirname $P`
	PROGNAME=`basename $P`
fi



if [[ $OPERATION == "start" ]]; then 
	if [[ -z $EUID ]]; then
		EUID=`id -u`
	fi
	if [[ $EUID -ne 0 ]]; then
		echo "$(basename $0) must be run with sudo."
		exit 1
	fi
fi


echo Running: $DIRNAME/netprobe.sh all $OPERATION 
$DIRNAME/netprobe.sh all $OPERATION 

