#! /bin/sh

# init file for Tidal Scheduling Agent 

# For RedHat and cousins:
# chkconfig: 2345 99 01
# description: Tidal Scheduling Agent
# processname: tagent
TZ=US/Eastern;export TZ


TAGENT_BIN=/opt/TIDAL/Agent/bin

 prog=tagent
   
    case "$1" in
        start)
            echo "Starting $prog: "
            su pvkl0adm -c "$TAGENT_BIN/tagent eastern_ld start"
            echo
            exit 0
            ;;
        stop)
            echo "Shutting down $prog: "
            su pvkl0adm -c "$TAGENT_BIN/tagent eastern_ld stop"
            echo
            ;;
        status)
            echo "Checking Status "
            su pvkl0adm -c "$TAGENT_BIN/tagent eastern_ld status"
            echo
            ;;
        restart)
            $0 stop
            $0 start
            ;;
        *)
            echo $"Usage: $0 {start|stop|restart|status}"
            RETVAL=1
    esac
    
    exit $RETVAL
