#!/bin/bash
#
# chkconfig: 3 98 10
# description: RVD start script --MDOE 11/14/2008
# Version 1.1
#
# processname: rvd.app rvd64.app
#
logger rvd.app init script START

if [ ! -x ${TSS_ROOT:=/opt/mds}/sitedefs/set_host_profile ]; then
   logger -s "$HOST could not determine host profile environment"
   exit 1
else
   . ${TSS_ROOT}/sitedefs/set_host_profile > /dev/null
fi
 
case $1 in
'start')
        # Check to ensure the log directories exist
	if [ ! -w $TSS_LOGS/rv ]; then
           mkdir -p $TSS_LOGS/rv
	   chown mdsadmin:mds $TSS_LOGS
	   chown mdsadmin:mds $TSS_LOGS/rv
	fi
       	chmod 777 $TSS_LOGS/rv  
        if [ -f $TSS_LOGS/rv/rvd.7502.log ]; then 
	    mv $TSS_LOGS/rv/rvd.7502.log $TSS_LOGS/rv/rvd.7502.log.`date +%y%m%d%H%M`
	fi
        if [ -f $TSS_LOGS/rv/rvd64.7502.log ]; then 
	    mv $TSS_LOGS/rv/rvd64.7502.log $TSS_LOGS/rv/rvd64.7502.log.`date +%y%m%d%H%M`
	fi
 	su - mdsadmin -c "${RV_BIN}/rvd app"
        ;;
'stop')
	/usr/bin/pkill -x 'rvd.app'
	/usr/bin/pkill -x 'rvd64.app'
	;;
'restart')      # stop then start
	/usr/bin/pkill -x 'rvd.app'
	/usr/bin/pkill -x 'rvd64.app'
	if [ -f $TSS_LOGS/rv/rvd.7502.log ]; then
	    mv $TSS_LOGS/rv/rvd.7502.log $TSS_LOGS/rv/rvd.7502.log.`date +%y%m%d%H%M`
	fi
	if [ -f $TSS_LOGS/rv/rvd64.7502.log ]; then
	    mv $TSS_LOGS/rv/rvd64.7502.log $TSS_LOGS/rv/rvd64.7502.log.`date +%y%m%d%H%M`
	fi
 	su - mdsadmin -c "${RV_BIN}/rvd app"
	;;
*)
        echo "Usage: $0 { start | stop | restart }"
        exit 1
        ;;
esac
logger rvd.app init script END
exit 0
