package mil.navy.e6b.wst.facade.test.trainer;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Executors;

import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;

public class FacadeProxyClient {

    private static int port = 23743; //23743; //3940; //
    private ClientBootstrap bootstrap;

    public static void main(String[] args) {

	new FacadeProxyClient().connect("wst-facade", port);

    }

    public void connect(String host, int port) {

	ChannelFactory factory = new NioClientSocketChannelFactory(
		Executors.newCachedThreadPool(),
		Executors.newCachedThreadPool());
	bootstrap = new ClientBootstrap(factory);
	bootstrap.setPipelineFactory(new ChannelPipelineFactory() {
	    public ChannelPipeline getPipeline() {
		return Channels.pipeline(new TcpClientHandler());
	    }
	});

	bootstrap.setOption("tcpNoDelay", true);
	bootstrap.setOption("keepAlive", true);
	// netty:allowDefaultCodec false
	bootstrap.setOption("allowDefaultCodec", true);
	// netty:sync false
	bootstrap.setOption("sync", false);
	// netty:sendBufferSize
	//bootstrap.setOption("sendBufferSize", 48000);
	ChannelFuture future = bootstrap.connect(new InetSocketAddress(host,
		port));
	Channel channel = future.awaitUninterruptibly().getChannel();

	byte[] aFacadeRequest = { 3, -111, 20, 0, 49, 50, 55, 46, 48, 46, 48,
		46, 49, 0, 0, 0, 0, 0, 0, 0 };
	byte[] aFacadeResponse = { 4, -111, 8, 0, 1, 0, 0, 0 };
	
	// *******************************************************************************
	// TODO: Set your bytestream here to send
	byte[] messageToSend = aFacadeResponse;


	for (int x=0; x < 1; x++) {
	    ChannelBuffer buffer = ChannelBuffers
		    .wrappedBuffer(messageToSend);
	    ChannelFuture aChannelFuture = channel.write(buffer);
	    System.out.println("Done? " + aChannelFuture.isDone());
	    
	    try {
		Thread.sleep(50);
	    } catch (InterruptedException e) {
		// TODO Auto-generated catch block
		e.printStackTrace();
	    }
	    
	}

	// Wait until the connection is closed or the connection attempt fails.
	/*channel.getCloseFuture().addListener(new ChannelFutureListener() {
	    @Override
	    public void operationComplete(ChannelFuture future)
		    throws Exception {
		new Thread(new Runnable() {
		    public void run() {
			// Shut down thread pools to exit
			// (cannot be executed in the same thread pool!
			bootstrap.releaseExternalResources();

			System.out.println("Shutting down");
		    }
		}).start();
	    }
	});*/
	
	channel.getCloseFuture().cancel();
	bootstrap.releaseExternalResources();
	bootstrap.shutdown();
	
	
    }

    public class TcpClientHandler extends SimpleChannelHandler {

	@Override
	public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) {

	    SocketAddress remoteAddress = ctx.getChannel().getRemoteAddress();

	    System.out.println("connection received from "
		    + remoteAddress.toString());

	    ChannelBuffer buf = (ChannelBuffer) e.getMessage();

	    System.out.println(NettyUtils.readString(buf));

	    e.getChannel().close();
	}

	@Override
	public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) {
	    e.getCause().printStackTrace();
	    e.getChannel().close();
	}
    }

    public static class NettyUtils {

	public static String readString(ChannelBuffer buf) {
	    StringBuilder sb = new StringBuilder();
	    while (buf.readable()) {
		sb.append((char) buf.readByte());
	    }

	    String message = sb.toString();
	    return message;
	}

    }

}
