package org.jboss.fuse.samples.route;

import org.apache.camel.builder.RouteBuilder;
import org.jboss.fuse.samples.exception.GenericHandlerException;
import org.jboss.fuse.samples.bean.MyRetryRuleset;
import org.jboss.fuse.samples.bean.TesterBean;

/**
 *
 */
public class TestRouteBuilder extends RouteBuilder {

    @Override
    public void configure() throws Exception {
 
        onException(GenericHandlerException.class)
        .retryWhile(bean(MyRetryRuleset.class));

        from("activemq:queue:foo")
        .convertBodyTo(String.class)
        .bean(TesterBean.class)
        .log("received body: ${body}");
    }
}
