package org.jboss.fuse.samples.bean;

import org.apache.camel.Exchange;
import org.apache.camel.Header;
import org.jboss.fuse.samples.exception.GenericHandlerException;
import org.jboss.fuse.samples.exception.ThreeRetryException;
import org.jboss.fuse.samples.exception.FiveRetryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MyRetryRuleset {
    private final Logger LOG = LoggerFactory.getLogger(MyRetryRuleset.class);

    public MyRetryRuleset() {}

    public boolean shouldRetry(
        @Header(Exchange.REDELIVERY_COUNTER) Integer counter,
        Exception causedBy) {
        LOG.info("causedBy is: " + causedBy.getClass().getName());
        LOG.info("counter is: " + counter);
        if (causedBy instanceof GenericHandlerException) {
            Exception rootEx = ((GenericHandlerException)causedBy).getRootException();
            LOG.info("rootException is: " + rootEx.getClass().getName());

            if (rootEx.getClass().equals(ThreeRetryException.class) && counter < 3) {
                return true;
            } else if (rootEx.getClass().equals(FiveRetryException.class) && counter < 5) {
                return true;
            } else {
                // add other exceptions and retry attempts
            }
        }
        return false;
    }
}
