package qa.com.cbq.netty.test;

import java.nio.charset.Charset;

import org.apache.camel.component.netty.ChannelHandlerFactory;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.handler.codec.frame.DelimiterBasedFrameDecoder;

public class XMLDelimiterFrameDecoder extends DelimiterBasedFrameDecoder implements ChannelHandlerFactory {
	private static final int maxFrameLength = 100000;
	private static final ChannelBuffer xmlDelimiter =  ChannelBuffers.copiedBuffer("/></XML>", Charset.defaultCharset());

	public XMLDelimiterFrameDecoder() {
		super(maxFrameLength, false, xmlDelimiter);
	}

	@Override
	// Just create a new unsharable ChannelHandler
	public ChannelHandler newChannelHandler() {
		return new XMLDelimiterFrameDecoder();
	}
}
