package com.sample;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;

import junit.framework.TestCase;

import org.jbpm.runtime.manager.impl.RuntimeEnvironmentBuilder;
import org.jbpm.services.task.identity.JBossUserGroupCallbackImpl;
import org.jbpm.services.task.impl.model.GroupImpl;
import org.jbpm.services.task.impl.model.UserImpl;
import org.jbpm.services.task.impl.model.PeopleAssignmentsImpl;
import org.jbpm.test.JBPMHelper;
import org.junit.Test;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeEnvironment;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.manager.RuntimeManagerFactory;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.task.TaskService;
import org.kie.api.task.UserGroupCallback;
import org.kie.api.task.model.Group;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.api.task.model.Task;
import org.kie.api.task.model.TaskSummary;
import org.kie.api.task.model.User;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.runtime.manager.context.EmptyContext;
import org.kie.internal.task.api.InternalTaskService;
import org.kie.internal.task.api.TaskModelProvider;
import org.kie.internal.task.api.model.InternalOrganizationalEntity;
import org.kie.internal.task.api.model.InternalPeopleAssignments;

import bitronix.tm.BitronixTransactionManager;
import bitronix.tm.TransactionManagerServices;

/**
 * This is a sample file to launch a process.
 */
public class ProcessJPATest extends TestCase {

    private static EntityManagerFactory emf;
    private BitronixTransactionManager tm;

    /**
     * @throws Exception
     */
    @Test
    public void testProcess() throws Exception {

        tm = TransactionManagerServices.getTransactionManager();

        try {

            setup();

            RuntimeManager manager = getRuntimeManager("sample-group.bpmn");
            // RuntimeManager manager =
            // getRuntimeManager("sample-explicit.bpmn");
            // RuntimeManager manager =
            // getRuntimeManager("sample-combined.bpmn");

            RuntimeEngine runtime = manager.getRuntimeEngine(EmptyContext.get());
            KieSession ksession = runtime.getKieSession();

            // start a new process instance
            Map<String, Object> params = new HashMap<String, Object>();
            ProcessInstance pi = ksession.startProcess("com.sample.bpmn.hello", params);
            System.out.println("A process instance started : pid = " + pi.getId());

            TaskService taskService = runtime.getTaskService();

            List<TaskSummary> listBetty = taskService.getTasksAssignedAsPotentialOwner("betty", "en-UK");
            TaskSummary taskBetty = listBetty.get(0);
            long taskIdBetty = taskBetty.getId();

            System.out.println("betty's taskId = "
                    + taskIdBetty
                    + ", status = "
                    + taskBetty.getStatus()
                    + ", CreatedBy = "
                    + taskBetty.getCreatedBy()
                    + ", actualOwner = "
                    + taskBetty.getActualOwner()
                    + ", Business Administrators = "
                    + taskService.getTaskById(taskIdBetty).getPeopleAssignments().getBusinessAdministrators()
                            .toString() + ", Potential Owners = "
                    + taskService.getTaskById(taskIdBetty).getPeopleAssignments().getPotentialOwners());

            // --- add betty as individual potential owner
            // addPotentialOwner(taskService, taskIdBetty, "user" , "betty");

            // Forwarding the task on behalf of the Group as a member
            // taskService.forward(taskIdBetty, "betty", "Group2");

            // Forwarding the task as a Business Administrator
            // taskService.forward(taskIdBetty, "Administrator", "Group2");

            // --- exclude betty
            // addExcludeOwner(taskService, taskIdBetty, "user", "betty");

            // --- add Group2 as Group potential owner
            // addPotentialOwner(taskService, taskIdBetty, "group", "Group2");

            // --- exclude Group1
            // addExcludeOwner(taskService, taskIdBetty, "group", "Group1");

            // --- forward from Group1 to Group2
            addPotentialOwnerGroup(taskService, taskIdBetty, "Group2");
            removePotentialOwnerGroup(taskService, taskIdBetty, "Group1");

            System.out.println("----- check john's task now who belongs to Group1 group");
            List<TaskSummary> listJohn = taskService.getTasksAssignedAsPotentialOwner("john", "en-UK");

            if (listJohn.isEmpty()) {
                System.out.println("There is no Task for john");
            } else {
                TaskSummary taskJohn = listJohn.get(0);
                long listJohnId = taskJohn.getId();
                System.out.println("john's taskId = " + listJohnId + ", status = " + taskJohn.getStatus()
                        + ", CreatedBy = " + taskJohn.getCreatedBy() + ", actualOwner = " + taskJohn.getActualOwner()
                        + ", Potential Owners = "
                        + taskService.getTaskById(listJohnId).getPeopleAssignments().getPotentialOwners());
            }

            System.out.println("----- check tommy's task now who belongs to Group2 group");
            List<TaskSummary> listTommy = taskService.getTasksAssignedAsPotentialOwner("tommy", "en-UK");
            if (listTommy.isEmpty()) {
                System.out.println("There is no Task for tommy");
            } else {
                TaskSummary listTommySummary = listTommy.get(0);
                long listTommyId = listTommySummary.getId();
                System.out.println("tommy taskId = " + listTommyId + ", status = " + listTommySummary.getStatus()
                        + ", CreatedBy = " + listTommySummary.getCreatedBy() + ", actualOwner = "
                        + listTommySummary.getActualOwner() + ", Potential Owners = "
                        + taskService.getTaskById(listTommyId).getPeopleAssignments().getPotentialOwners());
            }

            ksession.destroy();
            manager.disposeRuntimeEngine(runtime);

        } catch (Throwable th) {
            th.printStackTrace();
        }

        System.exit(0);
    }

    private void addPotentialOwnerGroup(TaskService taskService, long taskId, String groupId) throws Exception {

        try {
            tm.begin();
            Task task = taskService.getTaskById(taskId);
            List<OrganizationalEntity> potentialOwners = ((InternalPeopleAssignments) task.getPeopleAssignments())
                    .getPotentialOwners();
            OrganizationalEntity group = ((InternalTaskService) taskService).getOrganizationalEntityById(groupId);
            if (group == null) {
                group = TaskModelProvider.getFactory().newGroup();
                ((InternalOrganizationalEntity) group).setId(groupId);
                ((InternalTaskService)taskService).addGroup((Group)group);
            }
            potentialOwners.add(group);

            ((InternalPeopleAssignments) task.getPeopleAssignments()).setPotentialOwners(potentialOwners);
            System.out.println("Modified list of potential owners after PeopleAssignments has been modified = " + taskService.getTaskById(taskId).getPeopleAssignments().getPotentialOwners());
            tm.commit();

        } catch (Exception e) {
            e.printStackTrace();
            tm.rollback();
        }
    }
    
    private void removePotentialOwnerGroup(TaskService taskService, long taskId, String groupId) throws Exception {

        try {
            tm.begin();
            Task task = taskService.getTaskById(taskId);
            List<OrganizationalEntity> potentialOwners = ((InternalPeopleAssignments) task.getPeopleAssignments())
                    .getPotentialOwners();
            OrganizationalEntity group = ((InternalTaskService) taskService).getOrganizationalEntityById(groupId);
            potentialOwners.remove(group);

            ((InternalPeopleAssignments) task.getPeopleAssignments()).setPotentialOwners(potentialOwners);
            System.out.println("Modified list of potential owners after PeopleAssignments has been modified = " + taskService.getTaskById(taskId).getPeopleAssignments().getPotentialOwners());
            tm.commit();

        } catch (Exception e) {
            e.printStackTrace();
            tm.rollback();
        }
    }

    private static void setup() {
        // for H2 datasource
        JBPMHelper.startH2Server();
        JBPMHelper.setupDataSource();

        Map configOverrides = new HashMap();
        configOverrides.put("hibernate.hbm2ddl.auto", "create");
        configOverrides.put("hibernate.dialect", "org.hibernate.dialect.H2Dialect");

        emf = Persistence.createEntityManagerFactory("org.jbpm.persistence.jpa", configOverrides);

    }

    private static RuntimeManager getRuntimeManager(String process) {

        Properties properties = new Properties();
        properties.setProperty("betty", "Group1");
        properties.setProperty("john", "Group1");
        properties.setProperty("peter", "Group1");
        properties.setProperty("tommy", "Group2");
        properties.setProperty("hilfigure", "Group2");
        properties.setProperty("jeane", "Group2");

        UserGroupCallback userGroupCallback = new JBossUserGroupCallbackImpl(properties);
        System.out.println("Does the group 'Group1' exist in UserGroupCallback ??? "
                + userGroupCallback.existsGroup("Group1"));
        System.out.println("Does the group 'Group2' exist in UserGroupCallback ??? "
                + userGroupCallback.existsGroup("Group2"));

        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.getDefault().persistence(true)
                .entityManagerFactory(emf).userGroupCallback(userGroupCallback)
                .addAsset(ResourceFactory.newClassPathResource(process), ResourceType.BPMN2).get();
        return RuntimeManagerFactory.Factory.get().newPerProcessInstanceRuntimeManager(environment);

    }

}