package org.switchyard.quickstarts.rules.camel.cbr;

import java.util.Random;

import org.apache.camel.component.snmp.SnmpMessage;
import org.switchyard.Exchange;
import org.switchyard.Message;
import org.switchyard.component.camel.common.composer.CamelBindingData;
import org.switchyard.component.camel.common.composer.CamelMessageComposer;


/**
 * Composes/decomposes multiple parameter messages.
 * 
 */
public class TrainerCommonComposer extends CamelMessageComposer {
    
    private static final String[][] TESTS = new String[][] {
    	new String[] {"FF0000-ABC-123", "Red"},
        new String[] {"00FF00-DEF-456", "Green"},
        new String[] {"0000FF-GHI-789", "Blue"},
        new String[] {"0001FF-IJK-0123", "Purple"}
	    };

    @Override
    public Message compose(CamelBindingData source, Exchange exchange)
	    throws Exception {
	
	Object sourceObject = null;

	sourceObject = source.getMessage();
		
	TrainerCommonMessage aTrainerCommonMessage = new TrainerCommonMessage();
	aTrainerCommonMessage.setDataPayload("");
	aTrainerCommonMessage.setMsgID("");
	
	if (sourceObject != null) {
	    System.out.println("Source object is: " + sourceObject);
	}

	final Message composedMessage = exchange.createMessage();
	Random rand = new Random();

	Box box = new Box(TESTS[rand.nextInt(4)][0],new Widget(aTrainerCommonMessage));

	composedMessage.setContent(box);
	
	//System.out.println("Sending Composed Message with SysmanSNMP in a Box: " + composedMessage.getContent());

	return composedMessage;
    }

    @Override
    public CamelBindingData decompose(Exchange exchange, CamelBindingData target)
	    throws Exception {
	Object content = exchange.getMessage().getContent();
	String opName = exchange.getContract().getProviderOperation().getName();
	
	target = super.decompose(exchange, target);
	
	return super.decompose(exchange, target);
    }

}
