package org.switchyard.quickstarts.rules.camel.cbr;

import java.io.StringWriter;
import java.lang.reflect.*;
import java.util.*;

public class ObjectStateWriter {
    public StringWriter stringWriter;
    public String indent;
    private static String linefeed = "\r\n";

    private void write(String s, String s1) {
	stringWriter.write(indent);
	stringWriter.write("\tField: ");
	stringWriter.write(s);
	stringWriter.write(" = ");
	stringWriter.write(s1);
	stringWriter.write(linefeed);
    }

    private void writeArray(String s, Object aobj[]) {
	write(s, "Array (values following)");
	if (aobj.length == 0)
	    stringWriter.write(indent + "\t\t(no values)" + linefeed);
	for (int i = 0; i < aobj.length; i++)
	    new ObjectStateWriter(aobj[i], stringWriter, indent + "\t\t[" + i
		    + "] ");

    }

    private void writeVector(String s, Vector<?> vector) {
	write(s, "Vector (values following)");
	if (vector.size() == 0)
	    stringWriter.write(indent + "\t\t(no values)" + linefeed);
	for (int i = 0; i < vector.size(); i++)
	    new ObjectStateWriter(vector.elementAt(i), stringWriter, indent
		    + "\t\t[" + i + "] ");

    }

    private void writeHashtable(String s, Hashtable<?, ?> hashtable) {
	write(s, "Hashtable (values following)");
	if (hashtable.isEmpty())
	    stringWriter.write(indent + "\t\t(no values)" + linefeed);
	Enumeration<?> enumeration = hashtable.keys();
	for (int i = 0; enumeration.hasMoreElements(); i++) {
	    Object obj = enumeration.nextElement();
	    Object obj1 = hashtable.get(obj);
	    new ObjectStateWriter(obj, stringWriter, indent + "\t\t[key " + i
		    + "] ");
	    new ObjectStateWriter(obj1, stringWriter, indent + "\t\t[value "
		    + i + "] ");
	}

    }

    private void writePrimitive(Field field, Object obj) throws Exception {
	Object obj1 = field.get(obj);
	if (obj1 == null)
	    write(field.getName(), "null");
	else
	    write(field.getName(), obj1.toString());
    }

    private void writeArray(Field field, Object obj) throws Exception {
	Object obj1 = field.get(obj);
	if (obj1 == null)
	    write(field.getName(), "null");
	else
	    try {
		writeArray(field.getName(), (Object[]) field.get(obj));
	    } catch (Exception exception) {
		write(field.getName(), "Array (values following)");
		stringWriter.write(ArrayWriter.writeArray(field.get(obj),
			indent + "\t\t"));
	    }
    }

    private void writeUnion(Field field, Object obj) throws Exception {
	Object obj1 = field.get(obj);
	if (obj1 == null) {
	    write(field.getName(), "null");
	} else {
	    Field field1 = obj1.getClass().getDeclaredField("_value");
	    field1.setAccessible(true);
	    Object obj2 = field1.get(obj1);
	    if (obj2 == null) {
		write(field.getName(), "(empty)");
	    } else {
		int i = getKindOf(obj2.getClass());
		if (i == 2 || i == 1 || i == 8 || i == 0 || i == 3)
		    write(field.getName(), obj2.toString());
		else if (i == 4)
		    writeArray(field.getName(), (Object[]) obj2);
		else
		    writeObject(field.getName(), obj2);
	    }
	}
    }

    private void writeEnum(Field field, Object obj) throws Exception {
	Object obj1 = field.get(obj);
	if (obj1 == null) {
	    write(field.getName(), "null");
	} else {
	    Method method = obj1.getClass().getMethod("value", (Class[]) null);
	    Object obj2 = method.invoke((Object[]) obj1, (Object[]) null);
	    String s = null;
	    Field afield[] = obj1.getClass().getDeclaredFields();
	    AccessibleObject.setAccessible(afield, true);
	    boolean flag = false;
	    for (int i = 0; i < afield.length && !flag; i++) {
		Field field1 = afield[i];
		Object obj3 = field1.get(obj1);
		if (obj2.equals(obj3)) {
		    flag = true;
		    s = field1.getName().substring(1);
		}
	    }

	    write(field.getName(), s);
	}
    }

    private void writeVector(Field field, Object obj) throws Exception {
	Object obj1 = field.get(obj);
	if (obj1 == null)
	    write(field.getName(), "null");
	else
	    writeVector(field.getName(), (Vector<?>) obj1);
    }

    private void writeHashtable(Field field, Object obj) throws Exception {
	Object obj1 = field.get(obj);
	if (obj1 == null)
	    write(field.getName(), "null");
	else
	    writeHashtable(field.getName(), (Hashtable<?, ?>) obj1);
    }

    private void writeObject(Field field, Object obj) throws Exception {
	Object obj1 = field.get(obj);
	if (obj1 == null)
	    write(field.getName(), "null");
	else
	    writeObject(field.getName(), obj1);
    }

    private void writeObject(String s, Object obj) {
	write(s, "Instance " + obj.getClass().getName() + " follows:");
	new ObjectStateWriter(obj, stringWriter, indent + "\t|");
    }

    private int getKindOf(Class<?> class1) {

	if (class1.isPrimitive())
	    return 2;
	Class<?> class2 = class1.getSuperclass();
	if (class2 != null && class2.equals(java.lang.Number.class))
	    return 0;
	if (class1.isAssignableFrom(java.lang.String.class))
	    return 1;
	if (class1 == (java.util.Vector.class))
	    return 7;
	if (class1 == (java.util.Hashtable.class))
	    return 11;
	if (class1 == (java.lang.Character.class))
	    return 8;
	if (class1 == (java.util.Date.class))
	    return 3;
	if (class1 == (java.util.GregorianCalendar.class))
	    return 10;
	if (class1 == (java.lang.Integer.class))
	    return 0;
	if (class1.isArray())
	    return 4;
	if (class1.getName().endsWith("Union")
		|| class1.getName().endsWith("Union2")
		|| class1.getName().endsWith(".LocType"))
	    return 5;
	return !class1.getName().endsWith("Enum") ? 6 : 9;
    }

    private void writeAttribute(Field field, Object obj) throws Exception {
	int i = field.getModifiers();
	if (Modifier.isStatic(i))
	    return;
	switch (getKindOf(field.getType())) {
	case 0: // '\0'
	case 1: // '\001'
	case 2: // '\002'
	case 3: // '\003'
	case 8: // '\b'
	    writePrimitive(field, obj);
	    break;

	case 4: // '\004'
	    writeArray(field, obj);
	    break;

	case 5: // '\005'
	    writeUnion(field, obj);
	    break;

	case 9: // '\t'
	    writeEnum(field, obj);
	    break;

	case 7: // '\007'
	    writeVector(field, obj);
	    break;

	case 11: // '\013'
	    writeHashtable(field, obj);
	    break;

	case 10: // '\n'
	    // writeCalendar(field, obj);
	    break;

	case 6: // '\006'
	default:
	    writeObject(field, obj);
	    break;
	}
    }

    public ObjectStateWriter(Object obj, StringWriter stringwriter, String s) {
	stringWriter = stringwriter;
	indent = s;
	if (obj == null) {
	    stringwriter.write(s + obj + linefeed);
	    return;
	}
	Class<?> class1 = obj.getClass();
	switch (getKindOf(class1)) {
	case 0: // '\0'
	    stringwriter.write(s + obj.toString() + linefeed);
	    break;

	case 1: // '\001'
	    stringwriter.write(s + obj.toString() + linefeed);
	    break;

	case 10: // '\n'
	    // stringwriter.write(s +
	    // UtilsUTC.dateStringFromGregorianCalendar((GregorianCalendar)obj)
	    // + linefeed);
	    break;

	case 4: // '\004'
	    Class<?> class2 = class1.getComponentType();
	    if (class2.isPrimitive()) {
		for (int i = 0; i < Array.getLength(obj); i++)
		    write("", Array.get(obj, i).toString());

	    } else {
		String s1 = class1.getName();
		writeArray(s1, (Object[]) obj);
	    }
	    break;

	case 7: // '\007'
	    writeVector(class1.getName(), (Vector<?>) obj);
	    break;

	case 11: // '\013'
	    writeHashtable(class1.getName(), (Hashtable<?, ?>) obj);
	    break;

	case 2: // '\002'
	case 3: // '\003'
	case 5: // '\005'
	case 6: // '\006'
	case 8: // '\b'
	case 9: // '\t'
	default:
	    for (; class1 != null && class1 != (java.lang.Object.class); class1 = class1
		    .getSuperclass()) {
		Field afield[] = class1.getDeclaredFields();
		AccessibleObject.setAccessible(afield, true);
		if (stringwriter.getBuffer().length() == 0)
		    stringwriter.write(s
			    + "State Report for Instance of Class: "
			    + class1.getName() + linefeed);
		for (int j = 0; j < afield.length; j++)
		    if (!afield[j].getName().startsWith("this$"))
			try {
			    writeAttribute(afield[j], obj);
			} catch (Exception exception) {
			    write(afield[j].getName(), "Error writing field.");
			}

	    }

	    break;
	}
    }

    public static String getState(Object obj) {
	StringWriter stringwriter = new StringWriter();
	new ObjectStateWriter(obj, stringwriter, "");
	return stringwriter.toString();
    }

}
