package org.switchyard.quickstarts.rules.camel.cbr;

import javax.inject.Inject;

import org.apache.log4j.Logger;
import org.switchyard.component.bean.Reference;
import org.switchyard.component.bean.Service;

@Service(value = ProcessMessageService.class, name = "GreenService")
public class GreenServiceBean implements ProcessMessageService {

    private static final Logger LOGGER = Logger
	    .getLogger(GreenServiceBean.class);

    

    @Override
    public void processMessage(IFacadeMessage aFacadeMessage) {
	Box box = null;
	if (aFacadeMessage instanceof Box) {
	    box = (Box)aFacadeMessage;
	}
	
	LOGGER.info("Green service processing boxed widget with id: "
		+ box.getMsgID());
	if (box.getWidget().getEmbeddedMsg() instanceof SomeSortOfResponseMessage) {
	    LOGGER.warn("************ GOT A ROUTED RESPONSE! TODO: Should be Sending to Trainer Outbound");
	    
	}
    }
}
