package org.switchyard.quickstarts.rules.camel.cbr;

import org.snmp4j.CommunityTarget;
import org.snmp4j.PDU;
import org.snmp4j.PDUv1;
import org.snmp4j.Snmp;
import org.snmp4j.TransportMapping;
import org.snmp4j.mp.SnmpConstants;
import org.snmp4j.smi.IpAddress;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.UdpAddress;
import org.snmp4j.transport.DefaultUdpTransportMapping;

public class TrapSender {

    public static final String community = "public";

    // Sending Trap for sysLocation of RFC1213
    public static final String Oid = ".1.3.6.1.2.1.1.8";

    // IP of Local Host
    public static final String ipAddress = "127.0.0.1";

    // Ideally Port 162 should be used to send receive Trap, any other available
    // Port can be used
    public static final int port = 162;

    public static void main(String[] args) {
	TrapSender trapV1 = new TrapSender();
	trapV1.sendTrap_Version1();
    }

    /**
     * This methods sends the V1 trap to the Localhost in port 162
     */
    public void sendTrap_Version1() {
	try {
	    // Create Transport Mapping
	    TransportMapping transport = new DefaultUdpTransportMapping();
	    transport.listen();

	    // Create Target
	    CommunityTarget cTarget = new CommunityTarget();
	    cTarget.setCommunity(new OctetString(community));
	    cTarget.setVersion(SnmpConstants.version1);
	    cTarget.setAddress(new UdpAddress(ipAddress + "/" + port));
	    cTarget.setTimeout(5000);
	    cTarget.setRetries(2);

	    PDUv1 pdu = new PDUv1();
	    pdu.setType(PDU.V1TRAP);
	    pdu.setEnterprise(new OID(Oid));
	    pdu.setGenericTrap(PDUv1.ENTERPRISE_SPECIFIC);
	    pdu.setSpecificTrap(1);
	    pdu.setAgentAddress(new IpAddress(ipAddress));

	    // Send the PDU
	    Snmp snmp = new Snmp(transport);
	    System.out.println("Sending V1 Trap... ");
	    // snmp.send(pdu, cTarget);

	    for (int x = 0; x < 10000; x++) {
		snmp.send(pdu, cTarget);
		snmp.send(pdu, cTarget);
		snmp.send(pdu, cTarget);
		snmp.send(pdu, cTarget);
		snmp.send(pdu, cTarget);
		snmp.send(pdu, cTarget);
		snmp.send(pdu, cTarget);
		snmp.send(pdu, cTarget);
		snmp.send(pdu, cTarget);
		snmp.send(pdu, cTarget);
		snmp.send(pdu, cTarget);
		snmp.send(pdu, cTarget);
		snmp.send(pdu, cTarget);
		snmp.send(pdu, cTarget);
		snmp.send(pdu, cTarget);
		snmp.send(pdu, cTarget);
		snmp.send(pdu, cTarget);
		snmp.send(pdu, cTarget);
		snmp.send(pdu, cTarget);
		snmp.send(pdu, cTarget);
		snmp.send(pdu, cTarget);
		snmp.send(pdu, cTarget);
		snmp.send(pdu, cTarget);
		snmp.send(pdu, cTarget);
		snmp.send(pdu, cTarget);
		snmp.send(pdu, cTarget);
		snmp.send(pdu, cTarget);
		snmp.send(pdu, cTarget);
		snmp.send(pdu, cTarget);
		snmp.send(pdu, cTarget);
		Thread.sleep(50);
		System.out.println(x);
		// Thread.sleep(50);
	    }

	    Thread.sleep(50);

	    snmp.close();
	    System.out.println("Sent V1 Trap... ");
	} catch (Exception e) {
	    e.printStackTrace();
	}
    }

}