package org.switchyard.quickstarts.rules.camel.cbr;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;

public class TestStuff {

    private static final String[][] TESTS = new String[][] {
	    new String[] { "FF0000-ABC-123", "Red" },
	    new String[] { "00FF00-DEF-456", "Green" },
	    new String[] { "01FF00-EEF-456", "Purple" },
	    new String[] { "0000FF-GHI-789", "Blue" } };

    public static void main(String[] args) {
	TestStuff aTestStuff = new TestStuff();

	for (String[] test : TESTS) {
	    Box box = new Box(test[0], new Widget(new TrainerCommonMessage()));

	    System.out.println("This is a Box Facade Message ID "
		    + box.getMsgID());

	    aTestStuff.testit(box);

	}

    }

    private void testit(IFacadeMessage aFacadeMessage) {
	System.out.println("*** Testit: aFacadeMessage ID: "
		+ aFacadeMessage.getMsgID());
	if (aFacadeMessage.getMsgID().startsWith("FF0000")) {
	    aFacadeMessage.setDestination("Red");
	    System.out.println("*** Testit: aFacadeMessage ID: "
		    + aFacadeMessage.getMsgID() + " My destination is "
		    + aFacadeMessage.getDestination());
	}
	
	System.out.println(ObjectStateWriter.getState(aFacadeMessage));
	
	Class<?> base = aFacadeMessage.getClass();
	Method serverMethod = null;
	
	try {
	    //base = Class.forName("org.switchyard.quickstarts.rules.camel.cbr.IFacadeMessage");
	    base.getDeclaredMethods();
	    base.getField("destination").toString();
	    //serverMethod = base.getMethod("setDestination", String.class);
	    //serverMethod.invoke(base, new String("RED"));
	} catch (SecurityException e) {
	    // TODO Auto-generated catch block
	    e.printStackTrace();
	} catch (IllegalArgumentException e) {
	    // TODO Auto-generated catch block
	    e.printStackTrace();
	} catch (NoSuchFieldException e) {
	    // TODO Auto-generated catch block
	    e.printStackTrace();
	} 
	
	
    }

}
