package org.switchyard.quickstarts.rules.camel.cbr;

import java.util.Random;

import javax.inject.Inject;

import org.apache.log4j.Logger;
import org.switchyard.component.bean.Reference;
import org.switchyard.component.bean.Service;

@Service(value = ProcessMessageService.class, name = "RedService")
public class RedServiceBean implements ProcessMessageService {

private static final Logger LOGGER = Logger.getLogger(RedServiceBean.class);
    
    private static final String[][] TESTS = new String[][] {
    	new String[] {"FF0000-ABC-123", "Red"},
        new String[] {"00FF00-DEF-456", "Green"},
        new String[] {"0000FF-GHI-789", "Blue"},
        new String[] {"0001FF-IJK-0123", "Purple"}
	    };
    
    @Inject
    @Reference("RoutingService")
    private RoutingService routingActions;
    
    @Override
    public void processMessage(IFacadeMessage aFacadeMessage) {
	Box box = null;
	if (aFacadeMessage instanceof Box) {
	    box = (Box)aFacadeMessage;
	}
	
        LOGGER.info("Red service processing boxed widget with id: " + box.getMsgID());
        if (box.getWidget().getEmbeddedMsg() instanceof SomeSortOfResponseMessage) {
            LOGGER.warn("************ GOT A ROUTED RESPONSE!");
        }
        
        Random rand = new Random();

	Box rspBox = new Box(TESTS[rand.nextInt(4)][0],new Widget(new SomeSortOfResponseMessage()));

	routingActions.processRoute(rspBox);
    }


}
