package org.switchyard.quickstarts.rules.camel.cbr;

import org.apache.log4j.Logger;
import org.switchyard.component.bean.Service;

@Service(value = ProcessMessageService.class, name = "BlueService")
public class BlueServiceBean implements ProcessMessageService {

    private static final Logger LOGGER = Logger.getLogger(BlueServiceBean.class);
    
    @Override
    public void processMessage(IFacadeMessage aFacadeMessage) {
	Box box = null;
	if (aFacadeMessage instanceof Box) {
	    box = (Box)aFacadeMessage;
	}
	
        LOGGER.info("Blue service processing boxed widget with id: " + box.getMsgID());
        
        if (box.getWidget().getEmbeddedMsg() instanceof SomeSortOfResponseMessage) {
            LOGGER.warn("************ GOT A ROUTED RESPONSE!");
        }
    }

}
