package org.switchyard.quickstarts.rules.camel.cbr;

public class ArrayWriter {

    protected ArrayWriter() {
	buffer = new StringBuffer(100);
    }

    private int arrayContentsType(Object obj) {
	byte byte0 = -1;
	if (obj.getClass() == ia.getClass())
	    byte0 = 4;
	else if (obj.getClass() == ca.getClass())
	    byte0 = 1;
	else if (obj.getClass() == ba.getClass())
	    byte0 = 0;
	else if (obj.getClass() == ya.getClass())
	    byte0 = 2;
	else if (obj.getClass() == sa.getClass())
	    byte0 = 3;
	else if (obj.getClass() == la.getClass())
	    byte0 = 5;
	else if (obj.getClass() == fa.getClass())
	    byte0 = 6;
	else if (obj.getClass() == da.getClass())
	    byte0 = 7;
	return byte0;
    }

    protected void writeArrayContents(Object obj, String s) {
	switch (arrayContentsType(obj)) {
	case 4: // '\004'
	    writeIntArray(obj, s);
	    break;

	case 5: // '\005'
	    writeLongArray(obj, s);
	    break;

	case 0: // '\0'
	    writeBooleanArray(obj, s);
	    break;

	case 1: // '\001'
	    writeCharArray(obj, s);
	    break;

	case 2: // '\002'
	    writeByteArray(obj, s);
	    break;

	case 3: // '\003'
	    writeShortArray(obj, s);
	    break;

	case 6: // '\006'
	    writeFloatArray(obj, s);
	    break;

	case 7: // '\007'
	    writeDoubleArray(obj, s);
	    break;

	default:
	    buffer.append(s + "Could not write contents of "
		    + obj.getClass().getName() + ".");
	    break;
	}
    }

    private void writeIntArray(Object obj, String s) {
	int ai[] = (int[]) obj;
	for (int i = 0; i < ai.length; i++)
	    buffer.append(s + "[" + i + "] " + ai[i] + "\r\n");

	if (ai.length == 0)
	    buffer.append(s + "(no values)\r\n");
    }

    private void writeLongArray(Object obj, String s) {
	long al[] = (long[]) obj;
	for (int i = 0; i < al.length; i++)
	    buffer.append(s + "[" + i + "] " + al[i] + "\r\n");

	if (al.length == 0)
	    buffer.append(s + "(no values)\r\n");
    }

    private void writeBooleanArray(Object obj, String s) {
	boolean aflag[] = (boolean[]) obj;
	for (int i = 0; i < aflag.length; i++)
	    buffer.append(s + "[" + i + "] " + aflag[i] + "\r\n");

	if (aflag.length == 0)
	    buffer.append(s + "(no values)\r\n");
    }

    private void writeCharArray(Object obj, String s) {
	char ac[] = (char[]) obj;
	for (int i = 0; i < ac.length; i++)
	    buffer.append(s + "[" + i + "] " + ac[i] + "\r\n");

	if (ac.length == 0)
	    buffer.append(s + "(no values)\r\n");
    }

    private void writeByteArray(Object obj, String s) {
	byte abyte0[] = (byte[]) obj;
	for (int i = 0; i < abyte0.length; i++)
	    buffer.append(s + "[" + i + "] " + abyte0[i] + "\r\n");

	if (abyte0.length == 0)
	    buffer.append(s + "(no values)\r\n");
    }

    private void writeShortArray(Object obj, String s) {
	short aword0[] = (short[]) obj;
	for (int i = 0; i < aword0.length; i++)
	    buffer.append(s + "[" + i + "] " + aword0[i] + "\r\n");

	if (aword0.length == 0)
	    buffer.append(s + "(no values)\r\n");
    }

    private void writeFloatArray(Object obj, String s) {
	float af[] = (float[]) obj;
	for (int i = 0; i < af.length; i++)
	    buffer.append(s + "[" + i + "] " + af[i] + "\r\n");

	if (af.length == 0)
	    buffer.append(s + "(no values)\r\n");
    }

    private void writeDoubleArray(Object obj, String s) {
	double ad[] = (double[]) obj;
	for (int i = 0; i < ad.length; i++)
	    buffer.append(s + "[" + i + "] " + ad[i] + "\r\n");

	if (ad.length == 0)
	    buffer.append(s + "(no values)\r\n");
    }

    public static String writeArray(Object obj, String s) {
	ArrayWriter arraywriter = new ArrayWriter();
	arraywriter.writeArrayContents(obj, s);
	return arraywriter.buffer.toString();
    }

    protected StringBuffer buffer;
    private static final int BOOLEAN = 0;
    private static final int CHAR = 1;
    private static final int BYTE = 2;
    private static final int SHORT = 3;
    private static final int INT = 4;
    private static final int LONG = 5;
    private static final int FLOAT = 6;
    private static final int DOUBLE = 7;
    private static final Object ia = new int[0];
    private static final Object ca = new char[0];
    private static final Object ba = new boolean[0];
    private static final Object ya = new byte[0];
    private static final Object sa = new short[0];
    private static final Object la = new long[0];
    private static final Object fa = new float[0];
    private static final Object da = new double[0];

}
