/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.quickstarts.rules.camel.cbr;

import java.io.StringWriter;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Vector;
import org.switchyard.quickstarts.rules.camel.cbr.ArrayWriter;

public class ObjectStateWriter {
    public StringWriter stringWriter;
    public String indent;
    private static String linefeed = "\r\n";

    private void write(String s, String s1) {
        this.stringWriter.write(this.indent);
        this.stringWriter.write("\tField: ");
        this.stringWriter.write(s);
        this.stringWriter.write(" = ");
        this.stringWriter.write(s1);
        this.stringWriter.write(linefeed);
    }

    private void writeArray(String s, Object[] aobj) {
        this.write(s, "Array (values following)");
        if (aobj.length == 0) {
            this.stringWriter.write(this.indent + "\t\t(no values)" + linefeed);
        }
        for (int i = 0; i < aobj.length; ++i) {
            new ObjectStateWriter(aobj[i], this.stringWriter, this.indent + "\t\t[" + i + "] ");
        }
    }

    private void writeVector(String s, Vector<?> vector) {
        this.write(s, "Vector (values following)");
        if (vector.size() == 0) {
            this.stringWriter.write(this.indent + "\t\t(no values)" + linefeed);
        }
        for (int i = 0; i < vector.size(); ++i) {
            new ObjectStateWriter(vector.elementAt(i), this.stringWriter, this.indent + "\t\t[" + i + "] ");
        }
    }

    private void writeHashtable(String s, Hashtable<?, ?> hashtable) {
        this.write(s, "Hashtable (values following)");
        if (hashtable.isEmpty()) {
            this.stringWriter.write(this.indent + "\t\t(no values)" + linefeed);
        }
        Enumeration<?> enumeration = hashtable.keys();
        int i = 0;
        while (enumeration.hasMoreElements()) {
            Object obj = enumeration.nextElement();
            Object obj1 = hashtable.get(obj);
            new ObjectStateWriter(obj, this.stringWriter, this.indent + "\t\t[key " + i + "] ");
            new ObjectStateWriter(obj1, this.stringWriter, this.indent + "\t\t[value " + i + "] ");
            ++i;
        }
    }

    private void writePrimitive(Field field, Object obj) throws Exception {
        Object obj1 = field.get(obj);
        if (obj1 == null) {
            this.write(field.getName(), "null");
        } else {
            this.write(field.getName(), obj1.toString());
        }
    }

    private void writeArray(Field field, Object obj) throws Exception {
        Object obj1 = field.get(obj);
        if (obj1 == null) {
            this.write(field.getName(), "null");
        } else {
            try {
                this.writeArray(field.getName(), (Object[])field.get(obj));
            }
            catch (Exception exception) {
                this.write(field.getName(), "Array (values following)");
                this.stringWriter.write(ArrayWriter.writeArray(field.get(obj), this.indent + "\t\t"));
            }
        }
    }

    private void writeUnion(Field field, Object obj) throws Exception {
        Object obj1 = field.get(obj);
        if (obj1 == null) {
            this.write(field.getName(), "null");
        } else {
            Field field1 = obj1.getClass().getDeclaredField("_value");
            field1.setAccessible(true);
            Object obj2 = field1.get(obj1);
            if (obj2 == null) {
                this.write(field.getName(), "(empty)");
            } else {
                int i = this.getKindOf(obj2.getClass());
                if (i == 2 || i == 1 || i == 8 || i == 0 || i == 3) {
                    this.write(field.getName(), obj2.toString());
                } else if (i == 4) {
                    this.writeArray(field.getName(), (Object[])obj2);
                } else {
                    this.writeObject(field.getName(), obj2);
                }
            }
        }
    }

    private void writeEnum(Field field, Object obj) throws Exception {
        Object obj1 = field.get(obj);
        if (obj1 == null) {
            this.write(field.getName(), "null");
        } else {
            Method method = obj1.getClass().getMethod("value", null);
            Object obj2 = method.invoke((Object)((Object[])obj1), (Object[])null);
            String s = null;
            AccessibleObject[] afield = obj1.getClass().getDeclaredFields();
            AccessibleObject.setAccessible(afield, true);
            boolean flag = false;
            for (int i = 0; i < afield.length && !flag; ++i) {
                AccessibleObject field1 = afield[i];
                Object obj3 = ((Field)field1).get(obj1);
                if (!obj2.equals(obj3)) continue;
                flag = true;
                s = ((Field)field1).getName().substring(1);
            }
            this.write(field.getName(), s);
        }
    }

    private void writeVector(Field field, Object obj) throws Exception {
        Object obj1 = field.get(obj);
        if (obj1 == null) {
            this.write(field.getName(), "null");
        } else {
            this.writeVector(field.getName(), (Vector)obj1);
        }
    }

    private void writeHashtable(Field field, Object obj) throws Exception {
        Object obj1 = field.get(obj);
        if (obj1 == null) {
            this.write(field.getName(), "null");
        } else {
            this.writeHashtable(field.getName(), (Hashtable)obj1);
        }
    }

    private void writeObject(Field field, Object obj) throws Exception {
        Object obj1 = field.get(obj);
        if (obj1 == null) {
            this.write(field.getName(), "null");
        } else {
            this.writeObject(field.getName(), obj1);
        }
    }

    private void writeObject(String s, Object obj) {
        this.write(s, "Instance " + obj.getClass().getName() + " follows:");
        new ObjectStateWriter(obj, this.stringWriter, this.indent + "\t|");
    }

    private int getKindOf(Class<?> class1) {
        if (class1.isPrimitive()) {
            return 2;
        }
        Class<?> class2 = class1.getSuperclass();
        if (class2 != null && class2.equals(Number.class)) {
            return 0;
        }
        if (class1.isAssignableFrom(String.class)) {
            return 1;
        }
        if (class1 == Vector.class) {
            return 7;
        }
        if (class1 == Hashtable.class) {
            return 11;
        }
        if (class1 == Character.class) {
            return 8;
        }
        if (class1 == Date.class) {
            return 3;
        }
        if (class1 == GregorianCalendar.class) {
            return 10;
        }
        if (class1 == Integer.class) {
            return 0;
        }
        if (class1.isArray()) {
            return 4;
        }
        if (class1.getName().endsWith("Union") || class1.getName().endsWith("Union2") || class1.getName().endsWith(".LocType")) {
            return 5;
        }
        return !class1.getName().endsWith("Enum") ? 6 : 9;
    }

    private void writeAttribute(Field field, Object obj) throws Exception {
        int i = field.getModifiers();
        if (Modifier.isStatic(i)) {
            return;
        }
        switch (this.getKindOf(field.getType())) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 8: {
                this.writePrimitive(field, obj);
                break;
            }
            case 4: {
                this.writeArray(field, obj);
                break;
            }
            case 5: {
                this.writeUnion(field, obj);
                break;
            }
            case 9: {
                this.writeEnum(field, obj);
                break;
            }
            case 7: {
                this.writeVector(field, obj);
                break;
            }
            case 11: {
                this.writeHashtable(field, obj);
                break;
            }
            case 10: {
                break;
            }
            default: {
                this.writeObject(field, obj);
            }
        }
    }

    public ObjectStateWriter(Object obj, StringWriter stringwriter, String s) {
        Class<?> class1;
        this.stringWriter = stringwriter;
        this.indent = s;
        if (obj == null) {
            stringwriter.write(s + obj + linefeed);
            return;
        }
        switch (this.getKindOf(class1)) {
            case 0: {
                stringwriter.write(s + obj.toString() + linefeed);
                break;
            }
            case 1: {
                stringwriter.write(s + obj.toString() + linefeed);
                break;
            }
            case 10: {
                break;
            }
            case 4: {
                Class<?> class2 = class1.getComponentType();
                if (class2.isPrimitive()) {
                    for (int i = 0; i < Array.getLength(obj); ++i) {
                        this.write("", Array.get(obj, i).toString());
                    }
                    break;
                }
                String s1 = class1.getName();
                this.writeArray(s1, (Object[])obj);
                break;
            }
            case 7: {
                this.writeVector(class1.getName(), (Vector)obj);
                break;
            }
            case 11: {
                this.writeHashtable(class1.getName(), (Hashtable)obj);
                break;
            }
            default: {
                for (class1 = obj.getClass(); class1 != null && class1 != Object.class; class1 = class1.getSuperclass()) {
                    AccessibleObject[] afield = class1.getDeclaredFields();
                    AccessibleObject.setAccessible(afield, true);
                    if (stringwriter.getBuffer().length() == 0) {
                        stringwriter.write(s + "State Report for Instance of Class: " + class1.getName() + linefeed);
                    }
                    for (int j = 0; j < afield.length; ++j) {
                        if (((Field)afield[j]).getName().startsWith("this$")) continue;
                        try {
                            this.writeAttribute((Field)afield[j], obj);
                            continue;
                        }
                        catch (Exception exception) {
                            this.write(((Field)afield[j]).getName(), "Error writing field.");
                        }
                    }
                }
            }
        }
    }

    public static String getState(Object obj) {
        StringWriter stringwriter = new StringWriter();
        new ObjectStateWriter(obj, stringwriter, "");
        return stringwriter.toString();
    }
}

