package com.sample;

import static org.junit.Assert.assertTrue;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;

import bitronix.tm.resource.jdbc.PoolingDataSource;
import org.h2.tools.Server;
import org.jbpm.process.instance.command.UpdateTimerCommand;
import org.jbpm.runtime.manager.impl.RuntimeEnvironmentBuilder;
import org.jbpm.services.task.identity.JBossUserGroupCallbackImpl;
import org.jbpm.test.JBPMHelper;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeEnvironment;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.manager.RuntimeManagerFactory;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.task.UserGroupCallback;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * This is a sample file to launch a process.
 */
public class ProcessJPATest {

	private static Logger logger = LoggerFactory.getLogger(ProcessJPATest.class);

	private static EntityManagerFactory emf;

	private static Server h2Server;
	private static PoolingDataSource ds;

	@Before
	public void setup() {

		// for H2 datasource
		h2Server = JBPMHelper.startH2Server();
		ds = JBPMHelper.setupDataSource();

		Map configOverrides = new HashMap();
		configOverrides.put("hibernate.hbm2ddl.auto", "create");
		configOverrides.put("hibernate.dialect", "org.hibernate.dialect.H2Dialect");

		emf = Persistence.createEntityManagerFactory("org.jbpm.example", configOverrides);
	}

	@After
	public void teardown() {
		if (ds != null) {
			ds.close();
		}
		if (h2Server != null) {
			h2Server.shutdown();
		}
	}

	@Test
	public void testProcess() throws Exception {

		try {

			RuntimeManager manager = getRuntimeManager("sample.bpmn");
			RuntimeEngine runtime = manager.getRuntimeEngine(ProcessInstanceIdContext.get());
			KieSession ksession = runtime.getKieSession();

			// start a new process instance
			Map<String, Object> params = new HashMap<String, Object>();
			ProcessInstance pi = ksession.startProcess("com.sample.bpmn.hello", params);
			long processInstanceId = pi.getId();
			logger.info("A process instance started : pid = " + processInstanceId);

			// update timer to change wait time from 10 seconds to 5 seconds
			ksession.execute(new UpdateTimerCommand(processInstanceId, "MyTimer", 5));

			// -----------
			manager.disposeRuntimeEngine(runtime);

			logger.info("sleeping...");

			Thread.sleep(10000);

			assertTrue(true);

		} catch (Throwable th) {
			th.printStackTrace();
		}
	}

	private static RuntimeManager getRuntimeManager(String process) {
		Properties properties = new Properties();
		properties.setProperty("krisv", "");
		properties.setProperty("mary", "");
		properties.setProperty("john", "");
		UserGroupCallback userGroupCallback = new JBossUserGroupCallbackImpl(properties);

		RuntimeEnvironment environment = RuntimeEnvironmentBuilder.getDefault().persistence(true)
				.entityManagerFactory(emf).userGroupCallback(userGroupCallback)
				.addAsset(ResourceFactory.newClassPathResource(process), ResourceType.BPMN2).get();
		return RuntimeManagerFactory.Factory.get().newPerProcessInstanceRuntimeManager(environment);

	}
}