/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.rtgov.samples.jbossas.activityclient;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Scanner;
import java.util.Vector;
import javax.transaction.TransactionManager;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.codehaus.jackson.type.TypeReference;
import org.overlord.rtgov.activity.collector.ActivityCollector;
import org.overlord.rtgov.activity.collector.ActivityUnitLogger;
import org.overlord.rtgov.activity.collector.CollectorContext;
import org.overlord.rtgov.activity.collector.activity.server.ActivityServerLogger;
import org.overlord.rtgov.activity.embedded.EmbeddedActivityCollector;
import org.overlord.rtgov.activity.model.ActivityType;
import org.overlord.rtgov.activity.model.soa.RPCActivityType;
import org.overlord.rtgov.activity.model.soa.ResponseReceived;
import org.overlord.rtgov.activity.model.soa.ResponseSent;
import org.overlord.rtgov.activity.server.ActivityServer;
import org.overlord.rtgov.activity.server.rest.client.RESTActivityServer;

public class ActivityClient {
    private String _activityServerURL = null;
    private String _activityServerUsername = null;
    private String _activityServerPassword = null;
    private ActivityCollector _collector = null;
    private Random _random = new Random();
    private Map<String, File> _txnFileMap = new HashMap<String, File>();
    private List<String> _txnList = new Vector<String>();
    private static final String[] CUSTOMERS = new String[]{"Fred", "Joe", "Jane", "Lee", "Rachel", "Tina", "Kurt", "David", "Eric", "Kev", "Gary"};
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public static void main(String[] args) {
        if (args.length != 3) {
            System.err.println("Usage: ActivityClient <url> <filename> <numOfTxns>\r\nSet numOfTxns to -1 for continous");
            System.exit(1);
        }
        Scanner scanner = new Scanner(System.in);
        System.out.print("Enter username: ");
        String username = scanner.nextLine();
        System.out.print("Enter password: ");
        String password = scanner.nextLine();
        scanner.close();
        ActivityClient ac = new ActivityClient(args[0], username, password);
        ac.init();
        ac.loadTransactions(args[1]);
        try {
            ac.scheduleTxns(Integer.parseInt(args[2]));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ac.close();
    }

    public ActivityClient(String url, String username, String password) {
        this._activityServerURL = url;
        this._activityServerUsername = username;
        this._activityServerPassword = password;
    }

    public void init() {
        this._collector = new EmbeddedActivityCollector();
        RESTActivityServer restc = new RESTActivityServer();
        restc.setServerURL(this._activityServerURL);
        restc.setServerUsername(this._activityServerUsername);
        restc.setServerPassword(this._activityServerPassword);
        ActivityServerLogger activityUnitLogger = new ActivityServerLogger();
        activityUnitLogger.setActivityServer((ActivityServer)restc);
        activityUnitLogger.init();
        ((EmbeddedActivityCollector)this._collector).setActivityUnitLogger((ActivityUnitLogger)activityUnitLogger);
        ((EmbeddedActivityCollector)this._collector).setCollectorContext((CollectorContext)new TestCollectorContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            ActivityClient activityClient = this;
            synchronized (activityClient) {
                this.wait(2000L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this._collector instanceof EmbeddedActivityCollector) {
            ((EmbeddedActivityCollector)this._collector).getActivityUnitLogger().close();
        }
    }

    protected void preProcess(ActivityType actType, int txnId) {
        if (actType instanceof RPCActivityType) {
            RPCActivityType rpcType = (RPCActivityType)actType;
            rpcType.setMessageId(txnId + "-" + rpcType.getMessageId());
            if (rpcType instanceof ResponseSent) {
                ((ResponseSent)rpcType).setReplyToId(txnId + "-" + ((ResponseSent)rpcType).getReplyToId());
            }
            if (rpcType instanceof ResponseReceived) {
                ((ResponseReceived)rpcType).setReplyToId(txnId + "-" + ((ResponseReceived)rpcType).getReplyToId());
            }
        }
    }

    public void loadTransactions(String filename) {
        try {
            File f = null;
            URL url = ClassLoader.getSystemResource(filename);
            if (url == null) {
                f = new File(filename);
                if (!f.exists()) {
                    f = null;
                }
            } else {
                f = new File(url.getFile());
            }
            if (f == null) {
                throw new FileNotFoundException(filename);
            }
            FileInputStream is = new FileInputStream(f);
            Properties props = new Properties();
            props.load(is);
            is.close();
            for (String key : props.stringPropertyNames()) {
                if (!key.endsWith(".txn")) continue;
                String fn = props.getProperty(key);
                String name = key.substring(0, key.length() - 4);
                File txnFile = new File(f.getParentFile(), fn);
                if (!txnFile.exists()) {
                    System.err.println("Could not find transaction (" + name + ") file '" + fn + "' relative to: " + f.getParentFile());
                    continue;
                }
                this._txnFileMap.put(name, txnFile);
                String w = props.getProperty(name + ".weight");
                if (w != null) {
                    try {
                        int weight = Integer.parseInt(w);
                        for (int i = 0; i < weight; ++i) {
                            this._txnList.add(name);
                        }
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        continue;
                    }
                }
                System.err.println("Weight for '" + name + "' not found");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void scheduleTxns(int num) {
        Random rand = new Random(System.currentTimeMillis());
        for (int count = 0; num == -1 || count < num; ++count) {
            int txnpos = Math.abs(rand.nextInt()) % this._txnList.size();
            int custpos = Math.abs(rand.nextInt()) % CUSTOMERS.length;
            this.send(this._txnList.get(txnpos), CUSTOMERS[custpos], count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(String txnName, String customer, int count) {
        try {
            int id = count;
            InputStream is = new FileInputStream(this._txnFileMap.get(txnName));
            byte[] b = new byte[is.available()];
            is.read(b);
            is.close();
            String txn = new String(b);
            txn = txn.replaceAll("\\{ID\\}", "" + id);
            txn = txn.replaceAll("\\{CUSTOMER\\}", customer);
            is = new ByteArrayInputStream(txn.getBytes());
            List actTypes = (List)MAPPER.readValue(is, (TypeReference)new TypeReference<List<ActivityType>>(){});
            is.close();
            this._collector.startScope();
            for (ActivityType actType : actTypes) {
                this.preProcess(actType, id);
                if (actType.getTimestamp() > 0L) {
                    ActivityClient activityClient = this;
                    synchronized (activityClient) {
                        int variation = this._random.nextInt() % 20;
                        this.wait(actType.getTimestamp() + (long)variation);
                    }
                }
                this._collector.record(actType);
            }
            this._collector.endScope();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        SerializationConfig config = MAPPER.getSerializationConfig().withSerializationInclusion(JsonSerialize.Inclusion.NON_NULL).withSerializationInclusion(JsonSerialize.Inclusion.NON_DEFAULT);
        MAPPER.setSerializationConfig(config);
    }

    public class TestCollectorContext
    implements CollectorContext {
        public String getPrincipal() {
            return "ActivityClient";
        }

        public String getHost() {
            return "MyHost";
        }

        public String getNode() {
            return "MyNode";
        }

        public String getPort() {
            return "8080";
        }

        public TransactionManager getTransactionManager() {
            return null;
        }
    }
}

