package com.redhat.refarch.jdg.gasshopper;

import java.io.Serializable;
import java.util.Date;

public class PriceReport implements Serializable
{

	private static final long serialVersionUID = 1L;
	private String ipAddress;
	private Date date;
	private float regular;
	private float midgrade;
	private float premium;
	private float diesel;
	private String lastReportKey;

	public PriceReport(String ipAddress, float regular, float midgrade, float premium, float diesel)
	{
		this.ipAddress = ipAddress;
		this.regular = regular;
		this.midgrade = midgrade;
		this.premium = premium;
		this.diesel = diesel;
		this.date = new Date();
	}

	public Date getDate()
	{
		return date;
	}

	public void setDate(Date date)
	{
		this.date = date;
	}

	public String getIpAddress()
	{
		return ipAddress;
	}

	public float getRegular()
	{
		return regular;
	}

	public float getMidgrade()
	{
		return midgrade;
	}

	public float getPremium()
	{
		return premium;
	}

	public float getDiesel()
	{
		return diesel;
	}

	public String getLastReportKey()
	{
		return lastReportKey;
	}

	public void setLastReportKey(String lastReportKey)
	{
		this.lastReportKey = lastReportKey;
	}

	@Override
	public String toString()
	{
		return "PriceReport [ipAddress=" + ipAddress + ", date=" + date + ", regular=" + regular + ", midgrade=" + midgrade + ", premium=" + premium
				+ ", diesel=" + diesel + ", lastReportKey=" + lastReportKey + "]";
	}

}