package com.redhat.refarch.jdg.gasshopper;

import java.io.Serializable;
import java.util.UUID;

public class GasStation implements Serializable
{

	private static final long serialVersionUID = 1L;
	private String company;
	private String address;
	private String telephone;
	private Coordinates coordinates;
	private UUID stationId;

	public GasStation(String company, String address, String telephone, Coordinates coordinates)
	{
		this.company = company;
		this.address = address;
		this.telephone = telephone;
		this.coordinates = coordinates;
		this.stationId = UUID.randomUUID();
	}

	public String getCompany()
	{
		return company;
	}

	public String getAddress()
	{
		return address;
	}

	public String getTelephone()
	{
		return telephone;
	}

	public Coordinates getCoordinates()
	{
		return coordinates;
	}

	public UUID getStationId()
	{
		return stationId;
	}

	@Override
	public String toString()
	{
		return "GasStation [company=" + company + ", address=" + address + ", telephone=" + telephone + ", coordinates=" + coordinates
				+ ", stationId=" + stationId + "]";
	}
}