package com.redhat.refarch.jdg.gasshopper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Random;

public class PriceReportGenerator
{

	private static Random random = new Random( System.currentTimeMillis() );

	public static PriceReport getRandomPriceReport(float baseline, float variance)
	{
		int randomMax = ( (int)( variance * 10 ) * 2 + 1 );
		int randomInt = random.nextInt( randomMax );
		float adjustedInt = randomInt - ( ( randomMax - 1 ) / 2 );
		float deviation = adjustedInt / 10;
		float regular = baseline + deviation;
		regular = new BigDecimal( regular ).setScale( 2, RoundingMode.HALF_UP ).floatValue();
		float midgrade = new BigDecimal( regular + 0.1 ).setScale( 2, RoundingMode.HALF_UP ).floatValue();
		float premium = new BigDecimal( regular + 0.2 ).setScale( 2, RoundingMode.HALF_UP ).floatValue();
		float diesel = new BigDecimal( regular - 0.1 ).setScale( 2, RoundingMode.HALF_UP ).floatValue();
		PriceReport priceReport = new PriceReport( getRandomIP(), regular, midgrade, premium, diesel );
		return priceReport;
	}

	private static String getRandomIP()
	{
		int first = random.nextInt( 251 ) + 1;
		if( first >= 192 )
		{
			first += 3;
		}
		else if( first >= 172 )
		{
			first += 2;
		}
		else if( first >= 10 )
		{
			first++;
		}
		int second = random.nextInt( 256 );
		int third = random.nextInt( 256 );
		int fourth = random.nextInt( 255 ) + 1;
		return first + "." + second + "." + third + "." + fourth;
	}

}
