/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.refarch.jdg.gasshopper;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class Coordinates
implements Serializable {
    private static final long serialVersionUID = 1L;
    private double latitude;
    private double longitude;
    private static final double R = 3959.87;

    public Coordinates(double latitude, double longitude) {
        this.latitude = latitude;
        this.longitude = longitude;
    }

    public Coordinates(String latitude, String longitude) throws NumberFormatException {
        this.latitude = Double.parseDouble(latitude);
        this.longitude = Double.parseDouble(longitude);
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public double distance(Coordinates coordinates) {
        double dLat = Math.toRadians(coordinates.latitude - this.latitude);
        double dLon = Math.toRadians(coordinates.longitude - this.longitude);
        double lat1 = Math.toRadians(this.latitude);
        double lat2 = Math.toRadians(coordinates.latitude);
        double a = Math.sin(dLat / 2.0) * Math.sin(dLat / 2.0) + Math.sin(dLon / 2.0) * Math.sin(dLon / 2.0) * Math.cos(lat1) * Math.cos(lat2);
        double c = 2.0 * Math.asin(Math.sqrt(a));
        return 3959.87 * c;
    }

    public Coordinates calculateCellCenter() {
        double markerLatitude = Math.round(this.latitude);
        double markerLongitude = Math.round(this.longitude);
        return new Coordinates(markerLatitude, markerLongitude);
    }

    public Collection<Coordinates> calculateApplicableCellCenters(double radius) {
        Coordinates closestCellBorder = new Coordinates(Math.floor(this.latitude) + 0.5, Math.floor(this.longitude) + 0.5);
        if (this.distance(closestCellBorder) > radius) {
            ArrayList<Coordinates> cellCenters = new ArrayList<Coordinates>();
            cellCenters.add(this.calculateCellCenter());
            return cellCenters;
        }
        HashSet<Coordinates> cellBorders = new HashSet<Coordinates>();
        double firstLatitude = closestCellBorder.latitude;
        double firstLongitude = closestCellBorder.longitude;
        int latitudeIndex = 0;
        while (true) {
            int outerLoopSize = cellBorders.size();
            int longitudeIndex = 0;
            while (true) {
                int innerLoopSize = cellBorders.size();
                this.addIfWithinRadius(cellBorders, new Coordinates(firstLatitude + (double)latitudeIndex, firstLongitude + (double)longitudeIndex), radius);
                this.addIfWithinRadius(cellBorders, new Coordinates(firstLatitude + (double)latitudeIndex, firstLongitude - (double)longitudeIndex), radius);
                this.addIfWithinRadius(cellBorders, new Coordinates(firstLatitude - (double)latitudeIndex, firstLongitude + (double)longitudeIndex), radius);
                this.addIfWithinRadius(cellBorders, new Coordinates(firstLatitude - (double)latitudeIndex, firstLongitude - (double)longitudeIndex), radius);
                if (cellBorders.size() == innerLoopSize) break;
                ++longitudeIndex;
            }
            if (cellBorders.size() == outerLoopSize) break;
            ++latitudeIndex;
        }
        HashSet<Coordinates> cellCenters = new HashSet<Coordinates>();
        for (Coordinates cellBorder : cellBorders) {
            cellCenters.add(new Coordinates(Math.floor(cellBorder.latitude), Math.floor(cellBorder.longitude)));
            cellCenters.add(new Coordinates(Math.floor(cellBorder.latitude), Math.ceil(cellBorder.longitude)));
            cellCenters.add(new Coordinates(Math.ceil(cellBorder.latitude), Math.floor(cellBorder.longitude)));
            cellCenters.add(new Coordinates(Math.ceil(cellBorder.latitude), Math.ceil(cellBorder.longitude)));
        }
        return cellCenters;
    }

    private void addIfWithinRadius(Set<Coordinates> cellBorders, Coordinates candidate, double radius) {
        if (this.distance(candidate) <= radius) {
            cellBorders.add(candidate);
        }
    }

    public String asString() {
        return "(" + this.latitude + "," + this.longitude + ")";
    }

    public static Coordinates fromString(String coordinateString) {
        int separatorIndex = coordinateString.indexOf(44);
        String latitude = coordinateString.substring(1, separatorIndex);
        String longitude = coordinateString.substring(separatorIndex + 1, coordinateString.indexOf(41));
        Coordinates coordinates = new Coordinates(latitude, longitude);
        return coordinates;
    }

    public String toString() {
        return "Coordinates [latitude=" + this.latitude + ", longitude=" + this.longitude + "]";
    }
}

