/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.protocol;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.hotrod.exceptions.InvalidResponseException;
import org.infinispan.client.hotrod.exceptions.RemoteNodeSuspectException;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.protocol.HeaderParams;
import org.infinispan.client.hotrod.impl.transport.Transport;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.infinispan.commons.util.Util;

public class Codec20
implements Codec {
    private static final Log log = LogFactory.getLog(Codec20.class, Log.class);
    static final AtomicLong MSG_ID = new AtomicLong();
    final boolean trace = this.getLog().isTraceEnabled();

    @Override
    public HeaderParams writeHeader(Transport transport, HeaderParams params) {
        return this.writeHeader(transport, params, (byte)20);
    }

    protected HeaderParams writeHeader(Transport transport, HeaderParams params, byte version) {
        transport.writeByte((short)160);
        transport.writeVLong(params.messageId((long)Codec20.MSG_ID.incrementAndGet()).messageId);
        transport.writeByte(version);
        transport.writeByte(params.opCode);
        transport.writeArray(params.cacheName);
        int joinedFlags = HeaderParams.joinFlags(params.flags);
        transport.writeVInt(joinedFlags);
        transport.writeByte(params.clientIntel);
        transport.writeVInt(params.topologyId.get());
        if (this.trace) {
            this.getLog().tracef("Wrote header for message %d. Operation code: %#04x. Flags: %#x", params.messageId, params.opCode, joinedFlags);
        }
        return params;
    }

    @Override
    public short readHeader(Transport transport, HeaderParams params) {
        short magic = transport.readByte();
        Log localLog = this.getLog();
        if (magic != 161) {
            String message = "Invalid magic number. Expected %#x and received %#x";
            localLog.invalidMagicNumber((short)161, magic);
            if (this.trace) {
                localLog.tracef("Socket dump: %s", Util.hexDump((byte[])transport.dumpStream()));
            }
            throw new InvalidResponseException(String.format(message, (short)161, magic));
        }
        long receivedMessageId = transport.readVLong();
        if (receivedMessageId != params.messageId && receivedMessageId != 0L) {
            String message = "Invalid message id. Expected %d and received %d";
            localLog.invalidMessageId(params.messageId, receivedMessageId);
            if (this.trace) {
                localLog.tracef("Socket dump: %s", Util.hexDump((byte[])transport.dumpStream()));
            }
            throw new InvalidResponseException(String.format(message, params.messageId, receivedMessageId));
        }
        if (this.trace) {
            localLog.tracef("Received response for message id: %d", receivedMessageId);
        }
        short receivedOpCode = transport.readByte();
        short status = transport.readByte();
        this.readNewTopologyIfPresent(transport, params);
        if (receivedOpCode != params.opRespCode) {
            if (receivedOpCode == 80) {
                this.checkForErrorsInResponseStatus(transport, params, status);
            }
            throw new InvalidResponseException(String.format("Invalid response operation. Expected %#x and received %#x", params.opRespCode, receivedOpCode));
        }
        if (this.trace) {
            localLog.tracef("Received operation code is: %#04x", receivedOpCode);
        }
        return status;
    }

    @Override
    public Log getLog() {
        return log;
    }

    protected void checkForErrorsInResponseStatus(Transport transport, HeaderParams params, short status) {
        Log localLog = this.getLog();
        boolean isTrace = localLog.isTraceEnabled();
        if (isTrace) {
            localLog.tracef("Received operation status: %#x", status);
        }
        try {
            switch (status) {
                case 129: 
                case 130: 
                case 131: 
                case 132: 
                case 133: 
                case 134: {
                    String msgFromServer = transport.readString();
                    if (status == 134 && isTrace) {
                        localLog.tracef("Server-side timeout performing operation: %s", msgFromServer);
                    }
                    if (msgFromServer.contains("SuspectException") || msgFromServer.contains("SuspectedException")) {
                        if (isTrace) {
                            localLog.tracef("A remote node was suspected while executing messageId=%d. Check if retry possible. Message from server: %s", params.messageId, msgFromServer);
                        }
                        throw new RemoteNodeSuspectException(msgFromServer, params.messageId, status);
                    }
                    localLog.errorFromServer(msgFromServer);
                    throw new HotRodClientException(msgFromServer, params.messageId, status);
                }
            }
            throw new IllegalStateException(String.format("Unknown status: %#04x", status));
        }
        catch (Throwable throwable) {
            switch (status) {
                case 129: 
                case 130: 
                case 131: 
                case 132: {
                    transport.invalidate();
                }
            }
            throw throwable;
        }
    }

    protected void readNewTopologyIfPresent(Transport transport, HeaderParams params) {
        short topologyChangeByte = transport.readByte();
        if (topologyChangeByte == 1) {
            this.readNewTopologyAndHash(transport, params.topologyId);
        }
    }

    protected void readNewTopologyAndHash(Transport transport, AtomicInteger topologyId) {
        Log localLog = this.getLog();
        int newTopologyId = transport.readVInt();
        topologyId.set(newTopologyId);
        int clusterSize = transport.readVInt();
        SocketAddress[] addresses = new SocketAddress[clusterSize];
        for (int i = 0; i < clusterSize; ++i) {
            String host = transport.readString();
            int port = transport.readUnsignedShort();
            addresses[i] = new InetSocketAddress(host, port);
        }
        short hashFunctionVersion = transport.readByte();
        int numSegments = transport.readVInt();
        SocketAddress[][] segmentOwners = new SocketAddress[numSegments][];
        for (int i = 0; i < numSegments; ++i) {
            int numOwners = transport.readByte();
            segmentOwners[i] = new SocketAddress[numOwners];
            for (int j = 0; j < numOwners; ++j) {
                int memberIndex = transport.readVInt();
                segmentOwners[i][j] = addresses[memberIndex];
            }
        }
        List<SocketAddress> addressList = Arrays.asList(addresses);
        if (localLog.isInfoEnabled()) {
            localLog.newTopology(transport.getRemoteSocketAddress(), newTopologyId, addresses.length, new HashSet<SocketAddress>(addressList));
        }
        transport.getTransportFactory().updateServers(addressList);
        if (hashFunctionVersion == 0) {
            if (this.trace) {
                localLog.trace("Not using a consistent hash function (hash function version == 0).");
            }
        } else {
            transport.getTransportFactory().updateHashFunction(segmentOwners, numSegments, hashFunctionVersion);
        }
    }
}

