/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.impl;

import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.infinispan.protostream.BaseMarshaller;
import org.infinispan.protostream.Configuration;
import org.infinispan.protostream.EnumMarshaller;
import org.infinispan.protostream.MessageMarshaller;
import org.infinispan.protostream.RawProtobufMarshaller;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.impl.BaseMarshallerDelegate;
import org.infinispan.protostream.impl.EnumMarshallerDelegate;
import org.infinispan.protostream.impl.MessageMarshallerDelegate;
import org.infinispan.protostream.impl.RawProtobufMarshallerDelegate;

public final class SerializationContextImpl
implements SerializationContext {
    private final Configuration configuration;
    private Map<String, Descriptors.FileDescriptor> fileDescriptors = new ConcurrentHashMap<String, Descriptors.FileDescriptor>();
    private Map<String, Descriptors.Descriptor> messageDescriptors = new ConcurrentHashMap<String, Descriptors.Descriptor>();
    private Map<String, Descriptors.EnumDescriptor> enumDescriptors = new ConcurrentHashMap<String, Descriptors.EnumDescriptor>();
    private Map<String, BaseMarshallerDelegate<?>> marshallersByName = new ConcurrentHashMap();
    private Map<Class<?>, BaseMarshallerDelegate<?>> marshallersByClass = new ConcurrentHashMap();

    public SerializationContextImpl(Configuration configuration) {
        this.configuration = configuration;
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    private Descriptors.FileDescriptor[] resolveDeps(List<String> dependencyList, Map<String, Descriptors.FileDescriptor> map) {
        ArrayList<Descriptors.FileDescriptor> deps = new ArrayList<Descriptors.FileDescriptor>();
        for (String fileName : dependencyList) {
            if (map.containsKey(fileName)) {
                deps.add(map.get(fileName));
                continue;
            }
            if (!DescriptorProtos.getDescriptor().getName().equals(fileName)) continue;
            deps.add(DescriptorProtos.getDescriptor());
        }
        return deps.toArray(new Descriptors.FileDescriptor[deps.size()]);
    }

    @Override
    public void registerProtofile(InputStream in) throws IOException, Descriptors.DescriptorValidationException {
        DescriptorProtos.FileDescriptorSet descriptorSet = DescriptorProtos.FileDescriptorSet.parseFrom((InputStream)in);
        for (DescriptorProtos.FileDescriptorProto fdp : descriptorSet.getFileList()) {
            Descriptors.FileDescriptor[] deps = this.resolveDeps(fdp.getDependencyList(), this.fileDescriptors);
            Descriptors.FileDescriptor fd = Descriptors.FileDescriptor.buildFrom((DescriptorProtos.FileDescriptorProto)fdp, (Descriptors.FileDescriptor[])deps);
            this.registerProtofile(fd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerProtofile(String classpathResource) throws IOException, Descriptors.DescriptorValidationException {
        InputStream in = this.getClass().getResourceAsStream(classpathResource);
        if (in == null) {
            throw new IOException("Resource \"" + classpathResource + "\" does not exist");
        }
        try {
            this.registerProtofile(in);
        }
        finally {
            in.close();
        }
    }

    @Override
    public void registerProtofile(Descriptors.FileDescriptor fileDescriptor) {
        this.fileDescriptors.put(fileDescriptor.getName(), fileDescriptor);
        this.registerMessageDescriptors(fileDescriptor.getMessageTypes());
        this.registerEnumDescriptors(fileDescriptor.getEnumTypes());
    }

    private void registerMessageDescriptors(List<Descriptors.Descriptor> messageTypes) {
        for (Descriptors.Descriptor d : messageTypes) {
            this.messageDescriptors.put(d.getFullName(), d);
            this.registerMessageDescriptors(d.getNestedTypes());
            this.registerEnumDescriptors(d.getEnumTypes());
        }
    }

    private void registerEnumDescriptors(List<Descriptors.EnumDescriptor> enumTypes) {
        for (Descriptors.EnumDescriptor e : enumTypes) {
            this.enumDescriptors.put(e.getFullName(), e);
        }
    }

    @Override
    public Descriptors.Descriptor getMessageDescriptor(String fullName) {
        Descriptors.Descriptor descriptor = this.messageDescriptors.get(fullName);
        if (descriptor == null) {
            throw new IllegalArgumentException("Message descriptor not found : " + fullName);
        }
        return descriptor;
    }

    @Override
    public Descriptors.EnumDescriptor getEnumDescriptor(String fullName) {
        Descriptors.EnumDescriptor descriptor = this.enumDescriptors.get(fullName);
        if (descriptor == null) {
            throw new IllegalArgumentException("Enum descriptor not found : " + fullName);
        }
        return descriptor;
    }

    @Override
    public <T> void registerMarshaller(BaseMarshaller<T> marshaller) {
        BaseMarshallerDelegate marshallerDelegate;
        if (marshaller instanceof EnumMarshaller) {
            Descriptors.EnumDescriptor enumDescriptor = this.getEnumDescriptor(marshaller.getTypeName());
            marshallerDelegate = new EnumMarshallerDelegate((EnumMarshaller)marshaller, enumDescriptor);
        } else if (marshaller instanceof RawProtobufMarshaller) {
            marshallerDelegate = new RawProtobufMarshallerDelegate((RawProtobufMarshaller)marshaller, this);
        } else {
            Descriptors.Descriptor messageDescriptor = this.getMessageDescriptor(marshaller.getTypeName());
            marshallerDelegate = new MessageMarshallerDelegate((MessageMarshaller)marshaller, messageDescriptor);
        }
        this.marshallersByName.put(marshaller.getTypeName(), marshallerDelegate);
        this.marshallersByClass.put(marshaller.getJavaClass(), marshallerDelegate);
    }

    @Override
    public <T> void registerMarshaller(Class<? extends T> clazz, BaseMarshaller<T> marshaller) {
        if (!marshaller.getJavaClass().equals(clazz)) {
            throw new IllegalArgumentException("The given class must match the class reported by the marshaller.");
        }
        this.registerMarshaller(marshaller);
    }

    @Override
    public boolean canMarshall(Class clazz) {
        return this.marshallersByClass.containsKey(clazz);
    }

    @Override
    public boolean canMarshall(String descriptorFullName) {
        return this.messageDescriptors.containsKey(descriptorFullName) || this.enumDescriptors.containsKey(descriptorFullName);
    }

    @Override
    public <T> BaseMarshaller<T> getMarshaller(String descriptorFullName) {
        return this.getMarshallerDelegate(descriptorFullName).getMarshaller();
    }

    @Override
    public <T> BaseMarshaller<T> getMarshaller(Class<T> clazz) {
        return this.getMarshallerDelegate(clazz).getMarshaller();
    }

    <T> BaseMarshallerDelegate<T> getMarshallerDelegate(String descriptorFullName) {
        BaseMarshallerDelegate<?> marshallerDelegate = this.marshallersByName.get(descriptorFullName);
        if (marshallerDelegate == null) {
            throw new IllegalArgumentException("No marshaller registered for " + descriptorFullName);
        }
        return marshallerDelegate;
    }

    <T> BaseMarshallerDelegate<T> getMarshallerDelegate(Class<T> clazz) {
        BaseMarshallerDelegate<?> marshallerDelegate = this.marshallersByClass.get(clazz);
        if (marshallerDelegate == null) {
            throw new IllegalArgumentException("No marshaller registered for " + clazz);
        }
        return marshallerDelegate;
    }
}

